/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;

public class MergeResultsAction
extends AbstractPublisherAction {
    private IPublisherAction[] actions;
    private int mode;

    public MergeResultsAction(IPublisherAction[] actions, int mode) {
        this.actions = actions;
        this.mode = mode;
    }

    @Override
    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        MultiStatus finalStatus = new MultiStatus(MergeResultsAction.class.getName(), 0, "publishing result", null);
        IPublisherAction[] iPublisherActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            IPublisherAction action = iPublisherActionArray[n2];
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            PublisherResult result = new PublisherResult();
            finalStatus.merge(action.perform(publisherInfo, result, monitor));
            results.merge(result, this.mode);
            ++n2;
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        return Status.OK_STATUS;
    }
}

