/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryStatusHelper;
import org.eclipse.osgi.util.NLS;

public class FileInfoReader
extends Job
implements IRemoteFileSystemListener {
    private Exception exception;
    private IProgressMonitor theMonitor;
    private final int connectionRetryCount;
    private final long connectionRetryDelay;
    private final IConnectContext connectContext;
    final Boolean[] barrier = new Boolean[1];
    private IRemoteFile[] remoteFiles;
    private IRemoteFileSystemRequest browseRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        Boolean[] booleanArray = this.barrier;
        synchronized (this.barrier) {
            while (true) {
                if (this.barrier[0] != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Status.OK_STATUS;
                }
                try {
                    this.barrier.wait(1000L);
                    if (!this.theMonitor.isCanceled() || this.browseRequest == null) continue;
                    this.browseRequest.cancel();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void waitOnSelf() {
        this.schedule();
        while (this.barrier[0] == null) {
            boolean logged = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                if (logged) continue;
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Unexpected interrupt while waiting on ECF browse request", (Throwable)e));
            }
        }
    }

    public FileInfoReader(IConnectContext aConnectContext) {
        super(Messages.repo_loading);
        this.barrier[0] = null;
        this.setSystem(true);
        this.setUser(false);
        this.connectionRetryCount = RepositoryPreferences.getConnectionRetryCount();
        this.connectionRetryDelay = RepositoryPreferences.getConnectionMsRetryDelay();
        this.connectContext = aConnectContext;
    }

    public IRemoteFile[] getRemoteFiles(URI location, IProgressMonitor monitor) throws AuthenticationFailedException, FileNotFoundException, CoreException, JREHttpClientRequiredException {
        if (monitor != null) {
            monitor.beginTask(location.toString(), 1);
        }
        try {
            this.sendBrowseRequest(location, monitor);
            this.waitOnSelf();
            this.checkException(location, this.connectionRetryCount);
            IRemoteFile[] iRemoteFileArray = this.remoteFiles;
            return iRemoteFileArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IRemoteFile getRemoteFile(URI location, IProgressMonitor monitor) throws AuthenticationFailedException, FileNotFoundException, CoreException, JREHttpClientRequiredException {
        this.getRemoteFiles(location, monitor);
        return this.remoteFiles != null && this.remoteFiles.length > 0 ? this.remoteFiles[0] : null;
    }

    public long getLastModified(URI location, IProgressMonitor monitor) throws AuthenticationFailedException, FileNotFoundException, CoreException, JREHttpClientRequiredException {
        IRemoteFile file = this.getRemoteFile(location, monitor);
        if (file == null) {
            throw new FileNotFoundException(location.toString());
        }
        return file.getInfo().getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
        this.exception = event.getException();
        if (this.exception != null) {
            Boolean[] booleanArray = this.barrier;
            synchronized (this.barrier) {
                this.barrier[0] = Boolean.TRUE;
                this.barrier.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        if (event instanceof IRemoteFileSystemBrowseEvent) {
            IRemoteFileSystemBrowseEvent fsbe = (IRemoteFileSystemBrowseEvent)event;
            this.remoteFiles = fsbe.getRemoteFiles();
            if (this.theMonitor != null) {
                this.theMonitor.worked(1);
            }
            Boolean[] booleanArray = this.barrier;
            synchronized (this.barrier) {
                this.barrier[0] = Boolean.TRUE;
                this.barrier.notify();
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return;
            }
        }
        Boolean[] booleanArray = this.barrier;
        synchronized (this.barrier) {
            this.barrier[0] = Boolean.FALSE;
            this.barrier.notify();
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return;
        }
    }

    protected void sendBrowseRequest(URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        IContainer container;
        try {
            container = ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException e) {
            throw RepositoryStatusHelper.fromExceptionMessage(e, Messages.ecf_configuration_error);
        }
        IRemoteFileSystemBrowserContainerAdapter adapter = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
        if (adapter == null) {
            throw RepositoryStatusHelper.fromMessage(Messages.ecf_configuration_error);
        }
        adapter.setConnectContextForAuthentication(this.connectContext);
        this.exception = null;
        this.theMonitor = monitor;
        int retryCount = 0;
        while (true) {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getBrowseNamespace(), uri.toString());
                this.browseRequest = adapter.sendBrowseRequest(fileID, (IRemoteFileSystemListener)this);
            }
            catch (RemoteFileSystemException e) {
                this.exception = e;
            }
            catch (FileCreateException e) {
                this.exception = e;
            }
            if (this.checkException(uri, retryCount)) break;
            ++retryCount;
        }
    }

    protected Exception getException() {
        return this.exception;
    }

    private boolean checkException(URI uri, int attemptCounter) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        if (this.exception != null) {
            RepositoryStatusHelper.checkJREHttpClientRequired(this.exception);
            RepositoryStatusHelper.checkPermissionDenied(this.exception);
            RepositoryStatusHelper.checkFileNotFound(this.exception, uri);
            Throwable t = RepositoryStatusHelper.unwind(this.exception);
            if (t instanceof CoreException) {
                throw RepositoryStatusHelper.unwindCoreException((CoreException)t);
            }
            if (t instanceof IOException && attemptCounter < this.connectionRetryCount) {
                this.exception = null;
                try {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{uri.toString(), t.getMessage(), String.valueOf(attemptCounter)}), t));
                    Thread.sleep(this.connectionRetryDelay);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            throw RepositoryStatusHelper.wrap(this.exception);
        }
        return true;
    }
}

