/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib;

public final class JREData {
    private final int major;
    private final int minor;
    private final int micro;
    private final int bitness;
    private final String javaHome;

    public JREData(int major, int minor, int micro, int bitness) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.bitness = bitness;
        this.javaHome = "";
    }

    public JREData(String args) {
        this(args.split(" "));
    }

    public JREData(String[] args) {
        this.major = JREData.parseInt(args[0]);
        this.minor = JREData.parseInt(args[1]);
        this.micro = JREData.parseInt(args[2]);
        this.bitness = JREData.parseInt(args[3]);
        this.javaHome = args.length > 4 ? args[4].replace("%25", "%").replace("%20", " ") : "";
    }

    public JREData() {
        String version = System.getProperty("java.version");
        String[] segments = version.split("\\.");
        if (segments.length > 0) {
            this.major = JREData.parseInt(segments[0]);
            if (segments.length > 1) {
                this.minor = JREData.parseInt(segments[1]);
                this.micro = segments.length > 2 ? JREData.parseInt(segments[2]) : 0;
            } else {
                this.minor = 0;
                this.micro = 0;
            }
        } else {
            this.major = 0;
            this.minor = 0;
            this.micro = 0;
        }
        this.bitness = JREData.determineBitness();
        this.javaHome = System.getProperty("java.home");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getBitness() {
        return this.bitness;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public boolean satisfies(JREData requirement) {
        if (this.bitness != requirement.bitness) {
            return false;
        }
        if (this.major < requirement.major) {
            return false;
        }
        if (this.major > requirement.major) {
            return true;
        }
        if (this.minor < requirement.minor) {
            return false;
        }
        if (this.minor > requirement.minor) {
            return true;
        }
        return this.micro >= requirement.micro;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.major);
        result.append(' ');
        result.append(this.minor);
        result.append(' ');
        result.append(this.micro);
        result.append(' ');
        result.append(this.bitness);
        if (!"".equals(this.javaHome)) {
            result.append(' ');
            int i = 0;
            int length = this.javaHome.length();
            while (i < length) {
                char character = this.javaHome.charAt(i);
                switch (character) {
                    case ' ': {
                        result.append("%20");
                        break;
                    }
                    case '%': {
                        result.append("%25");
                        break;
                    }
                    default: {
                        result.append(character);
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    public static int determineBitness() {
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            return 64;
        }
        if (System.getProperty("os.arch").endsWith("64")) {
            return 64;
        }
        return 32;
    }

    private static int parseInt(String string) {
        int i = 0;
        while (i < string.length()) {
            if (!Character.isDigit(string.charAt(i))) {
                string = string.substring(0, i);
                break;
            }
            ++i;
        }
        return Integer.parseInt(string);
    }
}

