/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.net.Authenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.PreferenceManager;
import org.eclipse.core.internal.net.ProxyChangeEvent;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyType;
import org.eclipse.core.internal.net.StringMatcher;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProxyManager
implements IProxyService,
IEclipsePreferences.IPreferenceChangeListener {
    static final String PREF_NON_PROXIED_HOSTS = "nonProxiedHosts";
    static final String PREF_ENABLED = "proxiesEnabled";
    static final String PREF_OS = "systemProxiesEnabled";
    private static IProxyService proxyManager;
    private AbstractProxyProvider nativeProxyProvider;
    private PreferenceManager preferenceManager;
    ListenerList listeners = new ListenerList(1);
    private String[] nonProxiedHosts;
    private final ProxyType[] proxies = new ProxyType[]{new ProxyType("HTTP"), new ProxyType("HTTPS"), new ProxyType("SOCKS")};

    private ProxyManager() {
        try {
            this.nativeProxyProvider = (AbstractProxyProvider)Class.forName("org.eclipse.core.net.ProxyProvider").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            Activator.logInfo("Problems occured during the proxy provider initialization.", e);
        }
        this.preferenceManager = Activator.getInstance().getPreferenceManager();
    }

    public static synchronized IProxyService getProxyManager() {
        if (proxyManager == null) {
            proxyManager = new ProxyManager();
        }
        return proxyManager;
    }

    @Override
    public void addProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeProxyChangeListener(IProxyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireChange(final IProxyChangeEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final IProxyChangeListener listener = (IProxyChangeListener)l[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.proxyInfoChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    @Override
    public synchronized String[] getNonProxiedHosts() {
        this.checkMigrated();
        if (this.nonProxiedHosts == null) {
            String prop = this.preferenceManager.getString("", PREF_NON_PROXIED_HOSTS);
            this.nonProxiedHosts = ProxyType.convertPropertyStringToHosts(prop);
        }
        if (this.nonProxiedHosts.length == 0) {
            return this.nonProxiedHosts;
        }
        String[] result = new String[this.nonProxiedHosts.length];
        System.arraycopy(this.nonProxiedHosts, 0, result, 0, this.nonProxiedHosts.length);
        return result;
    }

    public String[] getNativeNonProxiedHosts() {
        if (this.hasSystemProxies()) {
            return this.nativeProxyProvider.getNonProxiedHosts();
        }
        return new String[0];
    }

    @Override
    public void setNonProxiedHosts(String[] hosts) {
        this.checkMigrated();
        Assert.isNotNull((Object)hosts);
        int i = 0;
        while (i < hosts.length) {
            String host = hosts[i];
            Assert.isNotNull((Object)host);
            Assert.isTrue((host.length() > 0 ? 1 : 0) != 0);
            ++i;
        }
        Object[] oldHosts = this.nonProxiedHosts;
        if (Arrays.equals(oldHosts, hosts)) {
            return;
        }
        this.nonProxiedHosts = hosts;
        this.preferenceManager.putString("", PREF_NON_PROXIED_HOSTS, ProxyType.convertHostsToPropertyString(this.nonProxiedHosts));
        try {
            this.preferenceManager.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the non-proxied hosts list", e);
        }
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(1, (String[])oldHosts, this.getNonProxiedHosts(), data, new IProxyData[0]);
        this.updateSystemProperties();
        this.fireChange(event);
    }

    @Override
    public IProxyData[] getProxyData() {
        this.checkMigrated();
        IProxyData[] result = new IProxyData[this.proxies.length];
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            result[i] = type.getProxyData(4);
            ++i;
        }
        return this.resolveType(result);
    }

    public IProxyData[] getNativeProxyData() {
        if (this.hasSystemProxies()) {
            return this.resolveType(this.nativeProxyProvider.getProxyData());
        }
        return new IProxyData[0];
    }

    @Override
    public void setProxyData(IProxyData[] proxies) {
        this.checkMigrated();
        this.doSetProxyData(proxies);
    }

    private void doSetProxyData(IProxyData[] proxyDatas) {
        IProxyData[] oldData = this.getProxyData();
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] changedProxies = this.internalSetProxyData(proxyDatas);
        if (changedProxies.length > 0) {
            ProxyChangeEvent event = new ProxyChangeEvent(3, hosts, hosts, oldData, changedProxies);
            this.fireChange(event);
        }
    }

    private IProxyData[] internalSetProxyData(IProxyData[] proxyDatas) {
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < proxyDatas.length) {
            IProxyData proxyData = proxyDatas[i];
            ProxyType type = this.getType(proxyData);
            if (type != null && type.setProxyData(proxyData)) {
                result.add(proxyData);
            }
            ++i;
        }
        return result.toArray(new IProxyData[result.size()]);
    }

    private ProxyType getType(IProxyData proxyData) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            if (type.getName().equals(proxyData.getType())) {
                return type;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isProxiesEnabled() {
        this.checkMigrated();
        return this.internalIsProxiesEnabled() && (!this.isSystemProxiesEnabled() || this.isSystemProxiesEnabled() && this.hasSystemProxies());
    }

    private boolean internalIsProxiesEnabled() {
        return this.preferenceManager.getBoolean("", PREF_ENABLED);
    }

    @Override
    public void setProxiesEnabled(boolean enabled) {
        this.checkMigrated();
        boolean current = this.internalIsProxiesEnabled();
        if (current == enabled) {
            return;
        }
        this.preferenceManager.putBoolean("", PREF_ENABLED, enabled);
    }

    private void internalSetEnabled(boolean enabled, boolean systemEnabled) {
        Properties sysProps = System.getProperties();
        sysProps.put("proxySet", enabled ? "true" : "false");
        sysProps.put("systemProxySet", systemEnabled ? "true" : "false");
        this.updateSystemProperties();
        try {
            this.preferenceManager.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("An error occurred while writing out the enablement state", e);
        }
        String[] hosts = this.getNonProxiedHosts();
        IProxyData[] data = this.getProxyData();
        ProxyChangeEvent event = new ProxyChangeEvent(2, hosts, hosts, data, data);
        this.fireChange(event);
    }

    private void updateSystemProperties() {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.updateSystemProperties(this.internalGetProxyData(type.getName(), 1));
            ++i;
        }
    }

    public void initialize() {
        this.checkMigrated();
        this.preferenceManager.addPreferenceChangeListener("", this);
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType type = this.proxies[i];
            type.initialize();
            ++i;
        }
        this.registerAuthenticator();
    }

    @Override
    public IProxyData getProxyData(String type) {
        this.checkMigrated();
        return this.resolveType(this.internalGetProxyData(type, 4));
    }

    private IProxyData internalGetProxyData(String type, int verifySystemProperties) {
        int i = 0;
        while (i < this.proxies.length) {
            ProxyType pt = this.proxies[i];
            if (pt.getName().equals(type)) {
                return pt.getProxyData(verifySystemProperties);
            }
            ++i;
        }
        return null;
    }

    @Override
    public IProxyData[] getProxyDataForHost(String host) {
        this.checkMigrated();
        if (!this.internalIsProxiesEnabled()) {
            return new IProxyData[0];
        }
        URI uri = ProxyManager.tryGetURI(host);
        if (uri == null) {
            return new IProxyData[0];
        }
        if (this.hasSystemProxies() && this.isSystemProxiesEnabled()) {
            return this.resolveType(this.nativeProxyProvider.select(uri));
        }
        if (this.isHostFiltered(uri)) {
            return new IProxyData[0];
        }
        IProxyData[] data = this.getProxyData();
        ArrayList<IProxyData> result = new ArrayList<IProxyData>();
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getHost() != null) {
                result.add(proxyData);
            }
            ++i;
        }
        IProxyData[] ret = result.toArray(new IProxyData[result.size()]);
        return this.resolveType(ret);
    }

    public static URI tryGetURI(String host) {
        try {
            int i = host.indexOf(":");
            if (i == -1) {
                return new URI("//" + host);
            }
            return new URI(host.substring(i + 1));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private boolean isHostFiltered(URI uri) {
        String[] filters = this.getNonProxiedHosts();
        int i = 0;
        while (i < filters.length) {
            String filter = filters[i];
            if (this.matchesFilter(uri.getHost(), filter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesFilter(String host, String filter) {
        StringMatcher matcher = new StringMatcher(filter, true, false);
        return matcher.match(host);
    }

    @Override
    public IProxyData getProxyDataForHost(String host, String type) {
        this.checkMigrated();
        if (!this.internalIsProxiesEnabled()) {
            return null;
        }
        if (this.hasSystemProxies() && this.isSystemProxiesEnabled()) {
            try {
                URI uri = new URI(type, "//" + host, null);
                IProxyData[] proxyDatas = this.nativeProxyProvider.select(uri);
                return proxyDatas.length > 0 ? this.resolveType(proxyDatas[0]) : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        IProxyData[] data = this.getProxyDataForHost(host);
        int i = 0;
        while (i < data.length) {
            IProxyData proxyData = data[i];
            if (proxyData.getType().equalsIgnoreCase(type) && proxyData.getHost() != null) {
                return this.resolveType(proxyData);
            }
            ++i;
        }
        return null;
    }

    private void registerAuthenticator() {
        Authenticator a = this.getPluggedInAuthenticator();
        if (a != null) {
            Authenticator.setDefault(a);
        }
    }

    private Authenticator getPluggedInAuthenticator() {
        IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            Activator.log(4, NLS.bind((String)"Authenticator {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (Authenticator)config.createExecutableExtension("class");
        }
        catch (CoreException ex) {
            Activator.log(4, NLS.bind((String)"Unable to instantiate authenticator {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    private synchronized void checkMigrated() {
        if (this.preferenceManager.isMigrated() || !Activator.getInstance().instanceLocationAvailable()) {
            return;
        }
        this.preferenceManager.migrate(this.proxies);
    }

    void migrateInstanceScopePreferences(Preferences instance, Preferences configuration, boolean isInitialize) {
        this.preferenceManager.migrateInstanceScopePreferences(instance, configuration, this.proxies, isInitialize);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(PREF_ENABLED) || event.getKey().equals(PREF_OS)) {
            this.checkMigrated();
            this.internalSetEnabled(this.preferenceManager.getBoolean("", PREF_ENABLED), this.preferenceManager.getBoolean("", PREF_OS));
        }
    }

    @Override
    public boolean hasSystemProxies() {
        return this.nativeProxyProvider != null;
    }

    @Override
    public boolean isSystemProxiesEnabled() {
        this.checkMigrated();
        return this.preferenceManager.getBoolean("", PREF_OS);
    }

    @Override
    public void setSystemProxiesEnabled(boolean enabled) {
        this.checkMigrated();
        boolean current = this.isSystemProxiesEnabled();
        if (current == enabled) {
            return;
        }
        this.preferenceManager.putBoolean("", PREF_OS, enabled);
    }

    @Override
    public IProxyData[] select(URI uri) {
        IProxyData data = this.getProxyDataForHost(uri.getHost(), uri.getScheme());
        if (data != null) {
            return this.resolveType(new IProxyData[]{data});
        }
        return new IProxyData[0];
    }

    public IProxyData resolveType(IProxyData data) {
        if (data == null) {
            return null;
        }
        ProxyData d = (ProxyData)data;
        if (d.getType().equalsIgnoreCase("HTTP")) {
            d.setType("HTTP");
        } else if (d.getType().equalsIgnoreCase("HTTPS")) {
            d.setType("HTTPS");
        } else if (d.getType().equalsIgnoreCase("SOCKS")) {
            d.setType("SOCKS");
        }
        return d;
    }

    public IProxyData[] resolveType(IProxyData[] data) {
        if (data == null) {
            return null;
        }
        int i = 0;
        while (i < data.length) {
            this.resolveType(data[i]);
            ++i;
        }
        return data;
    }
}

