/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerUtil;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleCheckbox;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.setup.internal.installer.SimpleMessageOverlay;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpleKeepInstallerPage
extends SimpleInstallerPage {
    private String location;
    private FlatButton applyButton;
    private SimpleCheckbox startMenuButton;
    private SimpleCheckbox desktopButton;
    private boolean startPermanentInstaller;

    public SimpleKeepInstallerPage(Composite parent, SimpleInstallerDialog dialog) {
        super(parent, dialog, true);
    }

    protected void createContent(Composite container) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 17;
        layout.marginRight = 11;
        layout.marginTop = 39;
        layout.marginBottom = 30;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setBackgroundMode(2);
        container.setBackground(AbstractSimpleDialog.COLOR_WHITE);
        Label title = new Label(container, 0);
        title.setText("Keep Installer");
        title.setForeground(UIUtil.getEclipseThemeColor());
        title.setFont(SimpleInstallerDialog.getFont(3, "bold"));
        title.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Label description = new Label(container, 64);
        description.setText("Copy the installer to a permanent location on your disk in order to remember your settings and support self updates.");
        description.setForeground(AbstractSimpleDialog.COLOR_LABEL_FOREGROUND);
        description.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).indent(0, 10).create());
        Composite varContainer = new Composite(container, 0);
        GridLayout varContainerLayout = new GridLayout(3, false);
        varContainerLayout.marginWidth = 0;
        varContainerLayout.marginHeight = 0;
        varContainerLayout.verticalSpacing = 3;
        varContainer.setLayout((Layout)varContainerLayout);
        varContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 48).create());
        Label copyToLabel = this.createLabel(varContainer, "Copy to");
        copyToLabel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(144, -1).create());
        final Text locationText = this.createTextField(varContainer);
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleKeepInstallerPage.this.location = locationText.getText();
                String error = this.validate();
                SimpleKeepInstallerPage.this.setErrorMessage(error);
                SimpleKeepInstallerPage.this.applyButton.setEnabled(error == null && SimpleKeepInstallerPage.this.location.length() != 0);
            }

            private String validate() {
                if (SimpleKeepInstallerPage.this.location.length() == 0) {
                    return null;
                }
                File folder = new File(SimpleKeepInstallerPage.this.location);
                if (!folder.exists()) {
                    return null;
                }
                if (!folder.isDirectory()) {
                    return "Path is not a directory.";
                }
                if (!this.isEmpty(folder)) {
                    return "Directory is not empty.";
                }
                return null;
            }

            private boolean isEmpty(File folder) {
                File[] children = folder.listFiles();
                return children == null || children.length == 0;
            }
        });
        ImageHoverButton folderButton = new ImageHoverButton(varContainer, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/folder_hover.png"));
        folderButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(12, 0).create());
        folderButton.setToolTipText("Browse" + StringUtil.HORIZONTAL_ELLIPSIS);
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                FileDialog chooser = new FileDialog(SimpleKeepInstallerPage.this.dialog.getShell(), 73728);
                chooser.setText("Keep Installer");
                if (!StringUtil.isEmpty((String)SimpleKeepInstallerPage.this.location)) {
                    File file = new File(SimpleKeepInstallerPage.this.location).getAbsoluteFile();
                    chooser.setFilterPath(file.getParent());
                    chooser.setFileName(file.getName());
                }
                if ((dir = chooser.open()) != null) {
                    locationText.setText(dir);
                }
            }
        });
        if (KeepInstallerUtil.getPowerShell() != null) {
            new Label(varContainer, 0);
            this.startMenuButton = this.createCheckbox(varContainer, "create start menu entry");
            this.startMenuButton.setChecked(true);
            new Label(varContainer, 0);
            this.desktopButton = this.createCheckbox(varContainer, "create desktop shortcut");
            this.desktopButton.setChecked(true);
        }
        new Label(varContainer, 0);
        this.applyButton = new FlatButton(varContainer, 8);
        this.applyButton.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, 43).hint(-1, 36).create());
        this.applyButton.setText("APPLY");
        this.applyButton.setBackground(SetupInstallerPlugin.getColor((int)50, (int)196, (int)0));
        this.applyButton.setForeground(AbstractSimpleDialog.COLOR_WHITE);
        this.applyButton.setFont(SimpleInstallerDialog.getFont(5, "bold"));
        this.applyButton.setCornerWidth(10);
        this.applyButton.setAlignment(0x1000000);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String launcher = OS.getCurrentLauncher((boolean)false);
                if (launcher != null) {
                    final boolean startMenu = SimpleKeepInstallerPage.this.startMenuButton == null ? false : SimpleKeepInstallerPage.this.startMenuButton.isChecked();
                    final boolean desktop = SimpleKeepInstallerPage.this.desktopButton == null ? false : SimpleKeepInstallerPage.this.desktopButton.isChecked();
                    ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog((Shell)SimpleKeepInstallerPage.this.getShell().getParent());
                    try {
                        progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Copying installer to " + SimpleKeepInstallerPage.this.location, -1);
                                KeepInstallerUtil.keepInstaller(SimpleKeepInstallerPage.this.location, SimpleKeepInstallerPage.this.startPermanentInstaller, launcher, startMenu, desktop, false);
                                UIUtil.getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        ((this).this).SimpleKeepInstallerPage.this.dialog.backSelected();
                                    }
                                });
                                monitor.done();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                    }
                }
            }
        });
        KeepInstallerDialog.setDefaultLocation(locationText);
    }

    public void setStartPermanentInstaller(boolean startPermanentInstaller) {
        this.startPermanentInstaller = startPermanentInstaller;
    }

    private SimpleCheckbox createCheckbox(Composite parent, String text) {
        SimpleCheckbox checkbox = new SimpleCheckbox(parent);
        checkbox.setLayoutData(GridDataFactory.swtDefaults().align(1, 1).span(2, 1).create());
        checkbox.setText(text);
        return checkbox;
    }

    private void setErrorMessage(String text) {
        if (text != null) {
            this.dialog.showMessage(text, SimpleMessageOverlay.Type.ERROR, false);
        }
    }
}

