/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.util.BytesResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveResourceImpl
extends ResourceImpl
implements BytesResource {
    private final URIConverter uriConverter;

    public ArchiveResourceImpl(URI uri, URIConverter uriConverter) {
        super(uri);
        this.uriConverter = uriConverter;
    }

    protected URIConverter getURIConverter() {
        return this.uriConverter != null ? this.uriConverter : super.getURIConverter();
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        URI archiveURI = this.getURI();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        EMap<String, String> details = annotation.getDetails();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            URI path = URI.createURI((String)name);
            int segmentCount = path.segmentCount();
            if (segmentCount > 2) {
                URI uri = URI.createURI((String)(String.valueOf(path.segment(0)) + "://" + path.segment(1)));
                int i = 2;
                int length = path.segmentCount();
                while (i < length) {
                    uri = uri.appendSegment(path.segment(i));
                    ++i;
                }
                URI archiveEntry = URI.createURI((String)("archive:" + archiveURI + "!/" + path));
                this.handle(details, uri, archiveEntry);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        this.getContents().add((Object)annotation);
    }

    protected void handle(EMap<String, String> details, URI uri, URI archiveEntry) {
        details.put((Object)uri.toString(), (Object)archiveEntry.toString());
    }
}

