/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class WhitespaceCharacterPainter
implements IPainter,
PaintListener {
    private static final char SPACE_SIGN = '\u00b7';
    private static final char IDEOGRAPHIC_SPACE_SIGN = '\u00b0';
    private static final char TAB_SIGN = '\u00bb';
    private static final char CARRIAGE_RETURN_SIGN = '\u00a4';
    private static final char LINE_FEED_SIGN = '\u00b6';
    private static final String SPACE_SIGN_STRING = String.valueOf('\u00b7');
    private static final String IDEOGRAPHIC_SPACE_SIGN_STRING = String.valueOf('\u00b0');
    private boolean fIsActive = false;
    private ITextViewer fTextViewer;
    private StyledText fTextWidget;
    private final boolean fIsAdvancedGraphicsPresent;
    private final boolean fIsFullSelectionStyle;
    private boolean fShowLeadingSpaces = true;
    private boolean fShowEnclosedSpace = true;
    private boolean fShowTrailingSpaces = true;
    private boolean fShowLeadingIdeographicSpaces = true;
    private boolean fShowEnclosedIdeographicSpaces = true;
    private boolean fShowTrailingIdeographicSpaces = true;
    private boolean fShowLeadingTabs = true;
    private boolean fShowEnclosedTabs = true;
    private boolean fShowTrailingTabs = true;
    private boolean fShowCarriageReturn = true;
    private boolean fShowLineFeed = true;
    private int fAlpha = 80;

    public WhitespaceCharacterPainter(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextWidget = textViewer.getTextWidget();
        GC gc = new GC((Drawable)this.fTextWidget);
        gc.setAdvanced(true);
        this.fIsAdvancedGraphicsPresent = gc.getAdvanced();
        gc.dispose();
        this.fIsFullSelectionStyle = (this.fTextWidget.getStyle() & 0x10000) != 0;
    }

    public WhitespaceCharacterPainter(ITextViewer viewer, boolean showLeadingSpaces, boolean showEnclosedSpaces, boolean showTrailingSpaces, boolean showLeadingIdeographicSpaces, boolean showEnclosedIdeographicSpaces, boolean showTrailingIdeographicSpace, boolean showLeadingTabs, boolean showEnclosedTabs, boolean showTrailingTabs, boolean showCarriageReturn, boolean showLineFeed, int alpha) {
        this(viewer);
        this.fShowLeadingSpaces = showLeadingSpaces;
        this.fShowEnclosedSpace = showEnclosedSpaces;
        this.fShowTrailingSpaces = showTrailingSpaces;
        this.fShowLeadingIdeographicSpaces = showLeadingIdeographicSpaces;
        this.fShowEnclosedIdeographicSpaces = showEnclosedIdeographicSpaces;
        this.fShowTrailingIdeographicSpaces = showTrailingIdeographicSpace;
        this.fShowLeadingTabs = showLeadingTabs;
        this.fShowEnclosedTabs = showEnclosedTabs;
        this.fShowTrailingTabs = showTrailingTabs;
        this.fShowCarriageReturn = showCarriageReturn;
        this.fShowLineFeed = showLineFeed;
        this.fAlpha = alpha;
    }

    @Override
    public void dispose() {
        this.fTextViewer = null;
        this.fTextWidget = null;
    }

    @Override
    public void paint(int reason) {
        IDocument document = this.fTextViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.redrawAll();
        } else if (reason == 16 || reason == 8) {
            this.redrawAll();
        }
    }

    @Override
    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw) {
                this.redrawAll();
            }
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event.gc, event.x, event.y, event.width, event.height);
        }
    }

    private void handleDrawRequest(GC gc, int x, int y, int w, int h) {
        int endLine;
        int startLine = this.fTextWidget.getLineIndex(y);
        if (startLine <= (endLine = this.fTextWidget.getLineIndex(y + h - 1)) && startLine < this.fTextWidget.getLineCount()) {
            Rectangle clipping = gc.getClipping();
            Rectangle clientArea = this.fTextWidget.getClientArea();
            int leftMargin = this.fTextWidget.getLeftMargin();
            int rightMargin = this.fTextWidget.getRightMargin();
            clientArea.x += leftMargin;
            clientArea.width -= leftMargin + rightMargin;
            clipping.intersect(clientArea);
            gc.setClipping(clientArea);
            if (this.fIsAdvancedGraphicsPresent) {
                int alpha = gc.getAlpha();
                gc.setAlpha(this.fAlpha);
                this.drawLineRange(gc, startLine, endLine, x, w);
                gc.setAlpha(alpha);
            } else {
                this.drawLineRange(gc, startLine, endLine, x, w);
            }
            gc.setClipping(clipping);
        }
    }

    private void drawLineRange(GC gc, int startLine, int endLine, int x, int w) {
        int viewPortWidth = this.fTextWidget.getClientArea().width;
        int spaceCharWidth = gc.stringExtent((String)" ").x;
        boolean spaceCharsAreSameWidth = spaceCharWidth == gc.stringExtent((String)WhitespaceCharacterPainter.SPACE_SIGN_STRING).x && spaceCharWidth == gc.stringExtent((String)WhitespaceCharacterPainter.IDEOGRAPHIC_SPACE_SIGN_STRING).x;
        StyleRangeWithMetricsOffsets cache = new StyleRangeWithMetricsOffsets();
        int line = startLine;
        while (line <= endLine) {
            int lineOffset = this.fTextWidget.getOffsetAtLine(line);
            int lineEndOffset = line < this.fTextWidget.getLineCount() - 1 ? this.fTextWidget.getOffsetAtLine(line + 1) : this.fTextWidget.getCharCount();
            int lineLength = lineEndOffset - lineOffset;
            while (lineLength > 0) {
                char c = this.fTextWidget.getTextRange(lineOffset + lineLength - 1, 1).charAt(0);
                if (c != '\r' && c != '\n') break;
                --lineLength;
            }
            Point endOfLine = this.fTextWidget.getLocationAtOffset(lineOffset + lineLength);
            if (x - endOfLine.x <= viewPortWidth) {
                int endOffset;
                int y = this.fTextWidget.getLinePixel(line);
                int startOffset = this.fTextWidget.getOffsetAtPoint(new Point(x, y)) - 1;
                if (startOffset == -1) {
                    startOffset = lineOffset;
                } else if (startOffset - 2 <= lineOffset) {
                    startOffset = lineOffset;
                }
                if (x + w >= endOfLine.x) {
                    endOffset = lineEndOffset;
                } else {
                    endOffset = this.fTextWidget.getOffsetAtPoint(new Point(x + w - 1, y)) + 1;
                    if (endOffset == -1) {
                        endOffset = lineEndOffset;
                    } else if (endOffset + 2 >= lineEndOffset) {
                        endOffset = lineEndOffset;
                    }
                }
                if (endOffset > startOffset) {
                    this.drawCharRange(gc, startOffset, endOffset, lineOffset, lineEndOffset, spaceCharsAreSameWidth, cache);
                }
            }
            ++line;
        }
    }

    private boolean isWhitespaceCharacter(char c) {
        return c == ' ' || c == '\u3000' || c == '\t' || c == '\r' || c == '\n';
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCharRange(GC gc, int startOffset, int endOffset, int lineOffset, int lineEndOffset, boolean spaceCharsAreSameWidth, StyleRangeWithMetricsOffsets cache) {
        StyledTextContent content = this.fTextWidget.getContent();
        String lineText = content.getTextRange(lineOffset, lineEndOffset - lineOffset);
        int startOffsetInLine = startOffset - lineOffset;
        int endOffsetInLine = endOffset - lineOffset;
        int textBegin = -1;
        int i = 0;
        while (i < lineText.length()) {
            if (!this.isWhitespaceCharacter(lineText.charAt(i))) {
                textBegin = i;
                break;
            }
            ++i;
        }
        boolean isEmptyLine = textBegin == -1;
        int textEnd = lineText.length() - 1;
        if (!isEmptyLine) {
            int i2 = lineText.length() - 1;
            while (i2 >= 0) {
                if (!this.isWhitespaceCharacter(lineText.charAt(i2))) {
                    textEnd = i2;
                    break;
                }
                --i2;
            }
        }
        StyleRange styleRange = null;
        Color fg = null;
        StringBuilder visibleChar = new StringBuilder(10);
        int delta = 0;
        int textOffset = startOffsetInLine;
        while (textOffset <= endOffsetInLine) {
            block48: {
                boolean eol;
                block47: {
                    eol = false;
                    ++delta;
                    if (textOffset >= endOffsetInLine) break block47;
                    char c = lineText.charAt(textOffset);
                    switch (c) {
                        case ' ': {
                            if (isEmptyLine) {
                                if (this.fShowLeadingSpaces || this.fShowEnclosedSpace || this.fShowTrailingSpaces) {
                                    visibleChar.append('\u00b7');
                                }
                            } else if (textOffset < textBegin) {
                                if (this.fShowLeadingSpaces) {
                                    visibleChar.append('\u00b7');
                                }
                            } else if (textOffset < textEnd) {
                                if (this.fShowEnclosedSpace) {
                                    visibleChar.append('\u00b7');
                                }
                            } else if (this.fShowTrailingSpaces) {
                                visibleChar.append('\u00b7');
                            }
                            if (!spaceCharsAreSameWidth || cache.contains(this.fTextWidget, lineOffset + textOffset)) {
                                break;
                            }
                            break block48;
                        }
                        case '\u3000': {
                            if (isEmptyLine) {
                                if (this.fShowLeadingIdeographicSpaces || this.fShowEnclosedIdeographicSpaces || this.fShowTrailingIdeographicSpaces) {
                                    visibleChar.append('\u00b0');
                                }
                            } else if (textOffset < textBegin) {
                                if (this.fShowLeadingIdeographicSpaces) {
                                    visibleChar.append('\u00b0');
                                }
                            } else if (textOffset < textEnd) {
                                if (this.fShowEnclosedIdeographicSpaces) {
                                    visibleChar.append('\u00b0');
                                }
                            } else if (this.fShowTrailingIdeographicSpaces) {
                                visibleChar.append('\u00b0');
                            }
                            if (!spaceCharsAreSameWidth) break;
                            break block48;
                        }
                        case '\t': {
                            if (isEmptyLine) {
                                if (!this.fShowLeadingTabs && !this.fShowEnclosedTabs && !this.fShowTrailingTabs) break;
                                visibleChar.append('\u00bb');
                                break;
                            }
                            if (textOffset < textBegin) {
                                if (!this.fShowLeadingTabs) break;
                                visibleChar.append('\u00bb');
                                break;
                            }
                            if (textOffset < textEnd) {
                                if (!this.fShowEnclosedTabs) break;
                                visibleChar.append('\u00bb');
                                break;
                            }
                            if (!this.fShowTrailingTabs) break;
                            visibleChar.append('\u00bb');
                            break;
                        }
                        case '\r': {
                            if (this.fShowCarriageReturn) {
                                if (visibleChar.length() > 0 && cache.contains(this.fTextWidget, lineOffset + textOffset)) {
                                    --textOffset;
                                    --delta;
                                    break;
                                }
                                visibleChar.append('\u00a4');
                            }
                            if (textOffset >= endOffsetInLine - 1 || lineText.charAt(textOffset + 1) != '\n') {
                                eol = true;
                                break;
                            }
                            break block48;
                        }
                        case '\n': {
                            if (this.fShowLineFeed) {
                                if (visibleChar.length() > 0 && cache.contains(this.fTextWidget, lineOffset + textOffset)) {
                                    --textOffset;
                                    --delta;
                                    break;
                                }
                                visibleChar.append('\u00b6');
                            }
                            eol = true;
                        }
                    }
                }
                if (visibleChar.length() > 0) {
                    int widgetOffset = startOffset + textOffset - startOffsetInLine - delta + 1;
                    if (!eol || !this.isFoldedLine(content.getLineAtOffset(widgetOffset))) {
                        if (!this.fTextWidget.getBlockSelection() && this.fIsFullSelectionStyle && WhitespaceCharacterPainter.isOffsetSelected(this.fTextWidget, widgetOffset)) {
                            fg = this.fTextWidget.getSelectionForeground();
                        } else if (styleRange == null || styleRange.start + styleRange.length <= widgetOffset) {
                            styleRange = this.fTextWidget.getStyleRangeAtOffset(widgetOffset);
                            fg = styleRange == null || styleRange.foreground == null ? this.fTextWidget.getForeground() : styleRange.foreground;
                        }
                        this.draw(gc, widgetOffset, visibleChar.toString(), fg, cache);
                    }
                    visibleChar.delete(0, visibleChar.length());
                }
                delta = 0;
            }
            ++textOffset;
        }
    }

    private static final boolean isOffsetSelected(StyledText widget, int offset) {
        Point selection = widget.getSelection();
        return offset >= selection.x && offset < selection.y;
    }

    private boolean isFoldedLine(int widgetLine) {
        ITextViewer iTextViewer = this.fTextViewer;
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)iTextViewer);
            int modelLine = extension.widgetLine2ModelLine(widgetLine);
            int widgetLine2 = extension.modelLine2WidgetLine(modelLine + 1);
            return widgetLine2 == -1;
        }
        return false;
    }

    private void redrawAll() {
        this.fTextWidget.redraw();
    }

    private void draw(GC gc, int offset, String s, Color fg, StyleRangeWithMetricsOffsets cache) {
        int baseline = this.fTextWidget.getBaseline(offset);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int fontBaseline = fontMetrics.getAscent() + fontMetrics.getLeading();
        int baslineDelta = baseline - fontBaseline;
        Point pos = this.fTextWidget.getLocationAtOffset(offset);
        StyleRange styleRange = cache.get(this.fTextWidget, offset);
        if (styleRange != null && styleRange.metrics != null) {
            String charBeforeOffset = " ";
            if (offset > 0) {
                charBeforeOffset = this.fTextWidget.getText(offset - 1, offset - 1);
            }
            Point extCharBeforeOffset = gc.textExtent(charBeforeOffset);
            pos.x = pos.x + styleRange.metrics.width - extCharBeforeOffset.x;
        }
        gc.setForeground(fg);
        gc.drawString(s, pos.x, pos.y + baslineDelta, true);
    }

    private static class StyleRangeWithMetricsOffsets {
        private Map<Integer, StyleRange> offsets = null;

        private StyleRangeWithMetricsOffsets() {
        }

        public boolean contains(StyledText st, int offset) {
            if (this.offsets == null) {
                this.fillMap(st);
            }
            return this.offsets.containsKey(offset);
        }

        public StyleRange get(StyledText st, int offset) {
            if (this.offsets == null) {
                this.fillMap(st);
            }
            StyleRange styleRange = this.offsets.get(offset);
            return styleRange;
        }

        private void fillMap(StyledText st) {
            this.offsets = new HashMap<Integer, StyleRange>();
            StyleRange[] ranges = st.getStyleRanges();
            if (ranges == null) {
                return;
            }
            StyleRange[] styleRangeArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                if (range != null && range.metrics != null) {
                    this.offsets.put(range.start, range);
                }
                ++n2;
            }
        }
    }
}

