/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.container;

import com.github.weisj.jsvg.attributes.Overflow;
import com.github.weisj.jsvg.attributes.PreserveAspectRatio;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.nodes.container.CommonRenderableContainerNode;
import com.github.weisj.jsvg.parser.impl.AttributeNode;
import com.github.weisj.jsvg.renderer.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.impl.NodeRenderer;
import com.github.weisj.jsvg.renderer.impl.context.RenderContextAccessor;
import com.github.weisj.jsvg.renderer.output.Output;
import com.github.weisj.jsvg.view.FloatSize;
import com.github.weisj.jsvg.view.ViewBox;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInnerViewContainer
extends CommonRenderableContainerNode {
    protected ViewBox viewBox;
    protected PreserveAspectRatio preserveAspectRatio;
    private Overflow overflow;

    @NotNull
    protected abstract Point2D outerLocation(@NotNull MeasureContext var1);

    @Nullable
    protected abstract Point2D anchorLocation(@NotNull MeasureContext var1);

    @NotNull
    public abstract FloatSize size(@NotNull RenderContext var1);

    @NotNull
    protected abstract Overflow defaultOverflow();

    @Nullable
    public ViewBox viewBox(@NotNull RenderContext context) {
        return this.viewBox != null ? this.viewBox : new ViewBox(this.size(context));
    }

    @NotNull
    public ViewBox staticViewBox(@NotNull FloatSize fallbackSize) {
        return this.viewBox != null ? this.viewBox : new ViewBox(fallbackSize);
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.viewBox = attributeNode.getViewBox();
        this.preserveAspectRatio = PreserveAspectRatio.parse(attributeNode.getValue("preserveAspectRatio"), attributeNode.parser());
        this.overflow = attributeNode.getEnum("overflow", this.defaultOverflow());
    }

    protected void renderWithCurrentViewBox(@NotNull RenderContext context, @NotNull Output output) {
        super.render(context, output);
    }

    @Override
    public void render(@NotNull RenderContext context, @NotNull Output output) {
        this.renderWithSize(this.size(context), this.viewBox(context), null, context, output);
    }

    @NotNull
    protected RenderContext createInnerContext(@NotNull RenderContext context, @NotNull ViewBox viewBox) {
        return NodeRenderer.setupInnerViewRenderContext(viewBox, context, true);
    }

    public final void renderWithSize(@NotNull FloatSize useSiteSize, @Nullable ViewBox view, @NotNull RenderContext context, @NotNull Output output) {
        this.renderWithSize(useSiteSize, view, null, context, output);
    }

    public final void renderWithSize(@NotNull FloatSize useSiteSize, @Nullable ViewBox view, @Nullable PreserveAspectRatio preserveAspectRatio, @NotNull RenderContext context, @NotNull Output output) {
        MeasureContext measureContext = context.measureContext();
        Point2D outerPos = this.outerLocation(measureContext);
        if (Length.isUnspecified(useSiteSize.width) || Length.isUnspecified(useSiteSize.height)) {
            FloatSize size = this.size(context);
            if (Length.isUnspecified(useSiteSize.width)) {
                useSiteSize.width = size.width;
            }
            if (Length.isUnspecified(useSiteSize.height)) {
                useSiteSize.height = size.height;
            }
        }
        if (preserveAspectRatio == null) {
            preserveAspectRatio = this.preserveAspectRatio;
        }
        AffineTransform viewTransform = view != null ? preserveAspectRatio.computeViewPortTransform(useSiteSize, view) : null;
        FloatSize viewSize = view != null ? view.size() : useSiteSize;
        RenderContext innerContext = this.createInnerContext(context, new ViewBox(viewSize));
        MeasureContext innerMeasure = innerContext.measureContext();
        innerContext.translate(output, outerPos);
        Point2D anchorPos = this.anchorLocation(innerMeasure);
        if (anchorPos != null) {
            if (viewTransform != null) {
                anchorPos.setLocation(anchorPos.getX() * viewTransform.getScaleX() - viewTransform.getTranslateX(), anchorPos.getY() * viewTransform.getScaleY() - viewTransform.getTranslateY());
            }
            innerContext.translate(output, anchorPos);
        }
        if (this.overflow.establishesClip()) {
            output.applyClip(new ViewBox(useSiteSize));
        }
        if (viewTransform != null) {
            innerContext.transform(output, viewTransform);
        }
        if (this instanceof SVG && ((SVG)this).isTopLevel()) {
            RenderContextAccessor.Accessor accessor = RenderContextAccessor.instance();
            accessor.setRootTransform(context, output.transform());
            accessor.setRootTransform(innerContext, output.transform());
            if (viewTransform != null && this.overflow.establishesClip()) {
                output.applyClip(view);
            }
        }
        this.renderWithCurrentViewBox(innerContext, output);
    }
}

