/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.ResourceManagerManger;

public class FormImages {
    private static FormImages instance;
    private final ResourceManagerManger manager = new ResourceManagerManger();
    private Map<Integer, AbstractImageDescriptor> descriptors;

    public static FormImages getInstance() {
        if (instance == null) {
            instance = new FormImages();
        }
        return instance;
    }

    private FormImages() {
    }

    public Image getSectionGradientImage(Color color1, Color color2, int realtheight, int theight, int marginHeight, Display display) {
        if (color1 == null || color1.isDisposed()) {
            return null;
        }
        SimpleSectionGradientImageDescriptor desc = new SimpleSectionGradientImageDescriptor(color1, color2, realtheight, theight, marginHeight);
        return this.getGradient(desc, display);
    }

    public Image getGradient(Color color1, Color color2, int realtheight, int theight, int marginHeight, Display display) {
        if (color1 == null || color1.isDisposed() || color2 == null || color2.isDisposed()) {
            return null;
        }
        SimpleImageDescriptor desc = new SimpleImageDescriptor(color1, color2, realtheight, theight, marginHeight);
        return this.getGradient(desc, display);
    }

    public Image getGradient(Color[] colors, int[] percents, int length, boolean vertical, Color bg, Display display) {
        if (colors.length == 0) {
            return null;
        }
        Color[] colorArray = colors;
        int n = colors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            if (color == null || color.isDisposed()) {
                return null;
            }
            ++n2;
        }
        if (bg != null && bg.isDisposed()) {
            return null;
        }
        ComplexImageDescriptor desc = new ComplexImageDescriptor(colors, length, percents, vertical, bg);
        return this.getGradient(desc, display);
    }

    private synchronized Image getGradient(AbstractImageDescriptor desc, Display display) {
        this.checkHashMaps();
        Image result = (Image)this.manager.getResourceManager(display).create((DeviceResourceDescriptor)desc);
        this.descriptors.put(result.hashCode(), desc);
        return result;
    }

    public synchronized boolean markFinished(Image image, Display display) {
        this.checkHashMaps();
        Integer imageHashCode = image.hashCode();
        AbstractImageDescriptor desc = this.descriptors.get(imageHashCode);
        if (desc != null) {
            LocalResourceManager resourceManager = this.manager.getResourceManager(display);
            resourceManager.destroy((DeviceResourceDescriptor)desc);
            if (resourceManager.find((DeviceResourceDescriptor)desc) == null) {
                this.descriptors.remove(imageHashCode);
                this.validateHashMaps();
            }
            return true;
        }
        image.dispose();
        this.validateHashMaps();
        return false;
    }

    private void checkHashMaps() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap<Integer, AbstractImageDescriptor>();
        }
    }

    private void validateHashMaps() {
        if (this.descriptors.isEmpty()) {
            this.descriptors = null;
        }
    }

    private static abstract class AbstractImageDescriptor
    extends ImageDescriptor {
        RGB[] fRGBs;
        int fLength;

        AbstractImageDescriptor(Color[] colors, int length) {
            this.fRGBs = new RGB[colors.length];
            int i = 0;
            while (i < colors.length) {
                Color color = colors[i];
                this.fRGBs[i] = color == null ? null : color.getRGB();
                ++i;
            }
            this.fLength = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AbstractImageDescriptor) {
                AbstractImageDescriptor id = (AbstractImageDescriptor)((Object)obj);
                return this.fLength == id.fLength && Arrays.equals(this.fRGBs, id.fRGBs);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            RGB[] rGBArray = this.fRGBs;
            int n = this.fRGBs.length;
            int n2 = 0;
            while (n2 < n) {
                RGB fRGB = rGBArray[n2];
                hash = hash * 7 + fRGB.hashCode();
                ++n2;
            }
            return hash * 7 + this.fLength;
        }
    }

    private class ComplexImageDescriptor
    extends AbstractImageDescriptor {
        RGB fBgRGB;
        boolean fVertical;
        int[] fPercents;

        public ComplexImageDescriptor(Color[] colors, int length, int[] percents, boolean vertical, Color bg) {
            super(colors, length);
            this.fBgRGB = bg == null ? null : bg.getRGB();
            this.fVertical = vertical;
            this.fPercents = percents;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ComplexImageDescriptor) {
                ComplexImageDescriptor id = (ComplexImageDescriptor)((Object)obj);
                if (super.equals(obj) && id.fVertical == this.fVertical && Arrays.equals(id.fPercents, this.fPercents)) {
                    if (Objects.equals(this.fBgRGB, id.fBgRGB)) {
                        return true;
                    }
                    int sum = 0;
                    int[] nArray = this.fPercents;
                    int n = this.fPercents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int fPercent = nArray[n2];
                        sum += fPercent;
                        ++n2;
                    }
                    if (sum >= 100) {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 7 + Boolean.hashCode(this.fVertical);
            int[] nArray = this.fPercents;
            int n = this.fPercents.length;
            int n2 = 0;
            while (n2 < n) {
                int fPercent = nArray[n2];
                hash = hash * 7 + Integer.hashCode(fPercent);
                ++n2;
            }
            return hash;
        }

        public ImageData getImageData(int zoom) {
            return null;
        }

        public Image createImage(boolean returnMissingImageOnError, Device device) {
            int width = this.fVertical ? 1 : this.fLength;
            int height = this.fVertical ? this.fLength : 1;
            ImageGcDrawer imageGcDrawer = (gc, iWidth, iHeight) -> {
                Color[] colors = new Color[this.fRGBs.length];
                int i = 0;
                while (i < colors.length) {
                    colors[i] = new Color(device, this.fRGBs[i]);
                    ++i;
                }
                Color bg = this.fBgRGB == null ? null : new Color(device, this.fBgRGB);
                this.drawTextGradient(gc, iWidth, iHeight, colors, this.fPercents, this.fVertical, bg);
            };
            Image gradient = new Image(device, imageGcDrawer, Math.max(width, 1), Math.max(height, 1));
            return gradient;
        }

        private void drawTextGradient(GC gc, int width, int height, Color[] colors, int[] percents, boolean vertical, Color bg) {
            Color oldBackground = gc.getBackground();
            if (colors.length == 1) {
                if (colors[0] != null) {
                    gc.setBackground(colors[0]);
                }
                gc.fillRectangle(0, 0, width, height);
            } else {
                Color oldForeground = gc.getForeground();
                Color lastColor = colors[0];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                int pos = 0;
                int i = 0;
                while (i < percents.length) {
                    gc.setForeground(lastColor);
                    lastColor = colors[i + 1];
                    if (lastColor == null) {
                        lastColor = oldBackground;
                    }
                    gc.setBackground(lastColor);
                    if (vertical) {
                        int gradientHeight = percents[i] * height / 100;
                        gc.fillGradientRectangle(0, pos, width, gradientHeight, true);
                        pos += gradientHeight;
                    } else {
                        int gradientWidth = percents[i] * width / 100;
                        gc.fillGradientRectangle(pos, 0, gradientWidth, height, false);
                        pos += gradientWidth;
                    }
                    ++i;
                }
                if (vertical && pos < height) {
                    if (bg != null) {
                        gc.setBackground(bg);
                    }
                    gc.fillRectangle(0, pos, width, height - pos);
                }
                if (!vertical && pos < width) {
                    if (bg != null) {
                        gc.setBackground(bg);
                    }
                    gc.fillRectangle(pos, 0, width - pos, height);
                }
                gc.setForeground(oldForeground);
            }
        }
    }

    private class SimpleImageDescriptor
    extends AbstractImageDescriptor {
        private final int fTheight;
        private final int fMarginHeight;

        SimpleImageDescriptor(Color color1, Color color2, int realtheight, int theight, int marginHeight) {
            super(new Color[]{color1, color2}, realtheight);
            this.fTheight = theight;
            this.fMarginHeight = marginHeight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SimpleImageDescriptor) {
                SimpleImageDescriptor id = (SimpleImageDescriptor)((Object)obj);
                if (super.equals(obj) && id.fTheight == this.fTheight && id.fMarginHeight == this.fMarginHeight) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 7 + Integer.valueOf(this.fTheight).hashCode();
            return hash * 7 + Integer.valueOf(this.fMarginHeight).hashCode();
        }

        public ImageData getImageData(int zoom) {
            return null;
        }

        public Image createImage(boolean returnMissingImageOnError, Device device) {
            Color color1 = new Color(device, this.fRGBs[0]);
            Color color2 = new Color(device, this.fRGBs[1]);
            ImageGcDrawer imageGcDrawer = (gc, width, height) -> {
                gc.setBackground(color1);
                gc.fillRectangle(0, 0, width, height);
                gc.setForeground(color2);
                gc.setBackground(color1);
                gc.fillGradientRectangle(0, this.fMarginHeight + 2, 1, this.fTheight - 2, true);
            };
            Image image = new Image(device, imageGcDrawer, 1, this.fLength);
            image.setBackground(color1);
            GC gc2 = new GC((Drawable)image);
            gc2.dispose();
            return image;
        }
    }

    private class SimpleSectionGradientImageDescriptor
    extends SimpleSectionImageDescriptor {
        SimpleSectionGradientImageDescriptor(Color color1, Color color2, int realtheight, int theight, int marginHeight) {
            super(new Color[]{color1, color2}, realtheight, theight, marginHeight);
        }

        @Override
        public Image createImage(boolean returnMissingImageOnError, Device device) {
            Color color1 = new Color(device, this.fRGBs[0]);
            Color color2 = new Color(device, this.fRGBs[1]);
            ImageGcDrawer imageGcDrawer = (gc, width, height) -> {
                gc.setBackground(color1);
                gc.fillRectangle(0, 0, width, height);
                gc.setForeground(color2);
                gc.setBackground(color1);
                gc.fillGradientRectangle(0, this.fMarginHeight + 2, 1, this.fTheight - 2, true);
            };
            Image image = new Image(device, imageGcDrawer, 1, this.fLength);
            image.setBackground(color1);
            return image;
        }
    }

    private class SimpleSectionImageDescriptor
    extends AbstractImageDescriptor {
        protected int fTheight;
        protected int fMarginHeight;

        SimpleSectionImageDescriptor(Color[] colors, int realtheight, int theight, int marginHeight) {
            super(colors, realtheight);
            this.fTheight = theight;
            this.fMarginHeight = marginHeight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SimpleSectionImageDescriptor) {
                SimpleSectionImageDescriptor id = (SimpleSectionImageDescriptor)((Object)obj);
                if (super.equals(obj) && id.fTheight == this.fTheight && id.fMarginHeight == this.fMarginHeight) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = super.hashCode();
            hash = hash * 7 + Integer.hashCode(this.fTheight);
            return hash * 7 + Integer.hashCode(this.fMarginHeight);
        }

        public ImageData getImageData(int zoom) {
            return null;
        }

        public Image createImage(boolean returnMissingImageOnError, Device device) {
            Color originalBgColor = new Color(device, this.fRGBs[0]);
            Color color1 = new Color(device, this.fRGBs[1]);
            ImageGcDrawer imageGcDrawer = (gc, width, height) -> {
                gc.setBackground(color1);
                gc.fillRectangle(0, this.fMarginHeight + 2, width, this.fTheight - this.fMarginHeight - 3);
                gc.setBackground(originalBgColor);
                gc.fillRectangle(0, this.fTheight - this.fMarginHeight - 4, 1, 4);
            };
            Image image = new Image(device, imageGcDrawer, 1, this.fLength);
            image.setBackground(originalBgColor);
            return image;
        }
    }
}

