/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

@Deprecated
public abstract class AbstractControlContentAssistSubjectAdapter
implements IContentAssistSubjectControl {
    protected static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/ContentAssistSubjectAdapters"));
    private List<VerifyKeyListener> fVerifyKeyListeners = new ArrayList<VerifyKeyListener>(1);
    private Set<KeyListener> fKeyListeners = new HashSet<KeyListener>(1);
    private Listener fControlListener;
    private ILabelProvider fCueLabelProvider;
    private ControlDecoration fControlDecoration;
    private Image fCachedDefaultCueImage;

    @Override
    public abstract Control getControl();

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.fKeyListeners.add(keyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#addKeyListener()");
        }
        this.installControlListener();
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        boolean deleted = this.fKeyListeners.remove(keyListener);
        if (DEBUG) {
            if (!deleted) {
                System.out.println("removeKeyListener -> wasn't here");
            }
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeKeyListener() -> " + this.fKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    @Override
    public boolean supportsVerifyKeyListener() {
        return true;
    }

    @Override
    public boolean appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#appendVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    @Override
    public boolean prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(0, verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#prependVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    @Override
    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.remove(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    @Override
    public void setEventConsumer(IEventConsumer eventConsumer) {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#setEventConsumer()");
        }
    }

    @Override
    public String getLineDelimiter() {
        return System.lineSeparator();
    }

    private void installControlListener() {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
        }
        if (this.fControlListener != null) {
            return;
        }
        this.fControlListener = new Listener(){

            public void handleEvent(Event e) {
                if (!AbstractControlContentAssistSubjectAdapter.this.getControl().isFocusControl()) {
                    return;
                }
                VerifyEvent verifyEvent = new VerifyEvent(e);
                KeyEvent keyEvent = new KeyEvent(e);
                switch (e.type) {
                    case 31: {
                        if (DEBUG) {
                            this.dump("before traverse", e, verifyEvent);
                        }
                        verifyEvent.doit = true;
                        for (VerifyKeyListener verifyKeyListener : AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners) {
                            verifyKeyListener.verifyKey(verifyEvent);
                            if (!verifyEvent.doit) {
                                e.detail = 0;
                                e.doit = true;
                                if (DEBUG) {
                                    this.dump("traverse eaten by verify", e, verifyEvent);
                                }
                                return;
                            }
                            if (!DEBUG) continue;
                            this.dump("traverse OK", e, verifyEvent);
                        }
                        break;
                    }
                    case 1: {
                        for (VerifyKeyListener verifyKeyListener : AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners) {
                            verifyKeyListener.verifyKey(verifyEvent);
                            if (verifyEvent.doit) continue;
                            e.doit = verifyEvent.doit;
                            if (DEBUG) {
                                this.dump("keyDown eaten by verify", e, verifyEvent);
                            }
                            return;
                        }
                        if (DEBUG) {
                            this.dump("keyDown OK", e, verifyEvent);
                        }
                        for (KeyListener keyListener : AbstractControlContentAssistSubjectAdapter.this.fKeyListeners) {
                            keyListener.keyPressed(keyEvent);
                        }
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }

            private void dump(String who, Event e, VerifyEvent ve) {
                StringBuilder sb = new StringBuilder("--- [AbstractControlContentAssistSubjectAdapter]\n");
                sb.append(who);
                sb.append(" - e: keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + e.doit);
                sb.append("; detail=" + e.detail + this.hex(e.detail));
                sb.append("; widget=" + String.valueOf(e.widget));
                sb.append("\n");
                sb.append("  verifyEvent keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + ve.doit);
                sb.append("; widget=" + String.valueOf(e.widget));
                System.out.println(sb);
            }

            private String hex(int i) {
                return "[0x" + Integer.toHexString(i) + "]";
            }
        };
        this.getControl().addListener(31, this.fControlListener);
        this.getControl().addListener(1, this.fControlListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() - installed");
        }
    }

    private void uninstallControlListener() {
        if (this.fControlListener == null || this.fKeyListeners.size() + this.fVerifyKeyListeners.size() != 0) {
            if (DEBUG) {
                System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
            }
            return;
        }
        this.getControl().removeListener(31, this.fControlListener);
        this.getControl().removeListener(1, this.fControlListener);
        this.fControlListener = null;
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() - done");
        }
    }

    public void setContentAssistCueProvider(ILabelProvider labelProvider) {
        if (this.fCueLabelProvider != null) {
            this.fCueLabelProvider.dispose();
        }
        this.fCueLabelProvider = labelProvider;
        if (labelProvider == null) {
            if (this.fControlDecoration != null) {
                this.fControlDecoration.dispose();
                this.fControlDecoration = null;
            }
        } else {
            if (this.fControlDecoration == null) {
                this.fControlDecoration = new ControlDecoration(this.getControl(), 16512);
                this.getControl().addDisposeListener(e -> {
                    if (this.fCueLabelProvider != null) {
                        this.fCueLabelProvider.dispose();
                        this.fCueLabelProvider = null;
                    }
                    if (this.fControlDecoration != null) {
                        this.fControlDecoration.dispose();
                        this.fControlDecoration = null;
                    }
                    if (this.fCachedDefaultCueImage != null) {
                        this.fCachedDefaultCueImage.dispose();
                        this.fCachedDefaultCueImage = null;
                    }
                });
                this.fControlDecoration.setShowHover(true);
                this.fControlDecoration.setShowOnlyOnFocus(true);
            }
            ILabelProviderListener listener = event -> {
                this.fControlDecoration.setDescriptionText(labelProvider.getText((Object)this.getControl()));
                Image image = labelProvider.getImage((Object)this.getControl());
                if (image == null) {
                    image = this.getDefaultCueImage();
                }
                this.fControlDecoration.setImage(image);
            };
            labelProvider.addListener(listener);
            listener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)labelProvider));
        }
    }

    private Image getDefaultCueImage() {
        if (this.fCachedDefaultCueImage == null) {
            ImageDescriptor cueID = ImageDescriptor.createFromFile(AbstractControlContentAssistSubjectAdapter.class, (String)"images/content_assist_cue.svg");
            this.fCachedDefaultCueImage = cueID.createImage((Device)this.getControl().getDisplay());
        }
        return this.fCachedDefaultCueImage;
    }
}

