/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.Messages;
import org.eclipse.osgi.util.NLS;

public final class LockFile {
    private final File file;
    private FileOutputStream stream;
    private FileLock lock;

    public LockFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized boolean isLocked() {
        return this.stream != null;
    }

    public synchronized void lock() throws IOException {
        if (this.stream == null) {
            try {
                this.stream = new FileOutputStream(this.file);
                this.lock = this.stream.getChannel().tryLock();
                if (this.lock == null) {
                    throw new IOException(NLS.bind((String)Messages.LockFile_CannotLock_exception, (Object)this.file));
                }
            }
            catch (IOException ex) {
                this.doRelease();
                throw ex;
            }
            catch (RuntimeException ex) {
                this.doRelease();
                throw ex;
            }
            catch (Error ex) {
                this.doRelease();
                throw ex;
            }
        }
    }

    public synchronized void unlock() {
        if (this.stream != null) {
            this.doRelease();
        }
    }

    private void doRelease() {
        block15: {
            block13: {
                if (this.lock != null) {
                    try {
                        try {
                            this.lock.release();
                        }
                        catch (Throwable ex) {
                            UtilPlugin.INSTANCE.log(ex);
                            this.lock = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.lock = null;
                        throw throwable;
                    }
                    this.lock = null;
                }
            }
            if (this.stream != null) {
                try {
                    try {
                        IOUtil.close(this.stream);
                    }
                    catch (Throwable ex) {
                        UtilPlugin.INSTANCE.log(ex);
                        this.stream = null;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    this.stream = null;
                    throw throwable;
                }
                this.stream = null;
            }
        }
        try {
            this.file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

