/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;

public enum EncryptedDataPacketType {
    SED,
    SEIPDv1,
    SEIPDv2,
    LIBREPGP_OED;


    public static EncryptedDataPacketType of(PGPEncryptedDataList pGPEncryptedDataList) throws PGPException {
        return EncryptedDataPacketType.of(pGPEncryptedDataList.getEncryptedData());
    }

    public static EncryptedDataPacketType of(InputStreamPacket inputStreamPacket) throws PGPException {
        if (inputStreamPacket instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)inputStreamPacket;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                return SEIPDv1;
            }
            if (symmetricEncIntegrityPacket.getVersion() == 2) {
                return SEIPDv2;
            }
            throw new UnsupportedPacketVersionException("Symmetrically-Encrypted Integrity-Protected Data Packet of unknown version encountered: " + symmetricEncIntegrityPacket.getVersion());
        }
        if (inputStreamPacket instanceof AEADEncDataPacket) {
            return LIBREPGP_OED;
        }
        if (inputStreamPacket instanceof SymmetricEncDataPacket) {
            return SED;
        }
        throw new PGPException("Unexpected packet type: " + inputStreamPacket.getClass().getName());
    }
}

