/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.impl;

import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.parser.impl.SeparatorMode;
import com.github.weisj.jsvg.util.ParserBase;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParserUtil {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    private ParserUtil() {
    }

    @NotNull
    private static String removeWhiteSpace(@NotNull String value) {
        return WHITESPACE_PATTERN.matcher(value).replaceAll("");
    }

    @Nullable
    public static String parseUrl(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("url(") || !value.endsWith(")")) {
            return ParserUtil.removeWhiteSpace(value);
        }
        return ParserUtil.removeWhiteSpace(value.substring(4, value.length() - 1));
    }

    public static int parseInt(@Nullable String value, int fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static float parseFloat(@Nullable String value, float fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public static Length parseNumber(@Nullable String value, @Nullable Length fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            return Unit.RAW.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static float @NotNull [] parseFloatList(@Nullable String value) {
        String[] values = ParserUtil.parseStringList(value, SeparatorMode.COMMA_AND_WHITESPACE, new String[0]);
        float[] ret = new float[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ParserUtil.parseFloat(values[i], 0.0f);
        }
        return ret;
    }

    public static double @NotNull [] parseDoubleList(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return new double[0];
        }
        ArrayList<Double> list = new ArrayList<Double>();
        ParserBase base = new ParserBase(value, 0);
        while (base.hasNext()) {
            list.add(base.nextDouble());
            base.consumeWhiteSpaceOrSeparator();
        }
        return list.stream().mapToDouble(Double::doubleValue).toArray();
    }

    @NotNull
    public static @NotNull String @NotNull [] parseStringList(@Nullable String value, SeparatorMode separatorMode) {
        return ParserUtil.parseStringList(value, separatorMode, new String[0]);
    }

    @Contract(value="_,_,!null -> !null")
    public static @NotNull String @Nullable [] parseStringList(@Nullable String value, SeparatorMode separatorMode, @NotNull String @Nullable [] fallback) {
        int i;
        if (value == null || value.isEmpty()) {
            return fallback;
        }
        ArrayList<String> list = new ArrayList<String>();
        int max = value.length();
        int start = 0;
        boolean inWhiteSpace = false;
        for (i = 0; i < max; ++i) {
            char c = value.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!inWhiteSpace && separatorMode.allowWhitespace() && i - start > 0) {
                    list.add(value.substring(start, i));
                    start = i + 1;
                }
                inWhiteSpace = true;
                continue;
            }
            inWhiteSpace = false;
            if (separatorMode.separator() == '\u0000' || c != separatorMode.separator()) continue;
            list.add(value.substring(start, i));
            start = i + 1;
        }
        if (i - start > 0) {
            list.add(value.substring(start, i));
        }
        return list.toArray(new String[0]);
    }
}

