/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityPatternBinding;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.internal.activities.ActivityPatternBinding;
import org.eclipse.ui.internal.util.Util;

final class Activity
implements IActivity {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Activity.class.getName().hashCode();
    private static final Set<Activity> strongReferences = new HashSet<Activity>();
    private Set<IActivityRequirementBinding> activityRequirementBindings;
    private transient IActivityRequirementBinding[] activityRequirementBindingsAsArray;
    private List<IActivityListener> activityListeners;
    private Set<IActivityPatternBinding> activityPatternBindings;
    private transient IActivityPatternBinding[] activityPatternBindingsAsArray;
    private boolean defined;
    private boolean enabled;
    private transient int hashCode = HASH_INITIAL;
    private final String id;
    private String name;
    private transient String string;
    private String description;
    private boolean defaultEnabled;
    private Expression expression;

    Activity(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.id = id;
    }

    @Override
    public void addActivityListener(IActivityListener activityListener) {
        if (activityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners == null) {
            this.activityListeners = new ArrayList<IActivityListener>();
        }
        if (!this.activityListeners.contains(activityListener)) {
            this.activityListeners.add(activityListener);
        }
        strongReferences.add(this);
    }

    @Override
    public int compareTo(IActivity object) {
        Activity castedObject = (Activity)object;
        int compareTo = Util.compare(this.activityRequirementBindingsAsArray, castedObject.activityRequirementBindingsAsArray);
        if (compareTo == 0 && (compareTo = Util.compare(this.activityPatternBindingsAsArray, castedObject.activityPatternBindingsAsArray)) == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare(this.enabled, castedObject.enabled)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void castedObject;
        if (!(object instanceof Activity)) {
            return false;
        }
        Activity activity = (Activity)object;
        return Objects.equals(this.activityRequirementBindings, castedObject.activityRequirementBindings) && Objects.equals(this.activityPatternBindings, castedObject.activityPatternBindings) && this.defined == castedObject.defined && this.enabled == castedObject.enabled && Objects.equals(this.id, castedObject.id) && Objects.equals(this.name, castedObject.name);
    }

    void fireActivityChanged(ActivityEvent activityEvent) {
        if (activityEvent == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            for (IActivityListener activityListener : this.activityListeners) {
                activityListener.activityChanged(activityEvent);
            }
        }
    }

    @Override
    public Set<IActivityRequirementBinding> getActivityRequirementBindings() {
        return this.activityRequirementBindings;
    }

    @Override
    public Set<IActivityPatternBinding> getActivityPatternBindings() {
        return this.activityPatternBindings;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.name;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.activityRequirementBindings);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.activityPatternBindings);
            this.hashCode = this.hashCode * 89 + Boolean.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Boolean.hashCode(this.enabled);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.name);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMatch(String string) {
        if (this.isDefined()) {
            for (IActivityPatternBinding iActivityPatternBinding : this.activityPatternBindings) {
                ActivityPatternBinding activityPatternBinding = (ActivityPatternBinding)iActivityPatternBinding;
                if (!activityPatternBinding.isMatch(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeActivityListener(IActivityListener activityListener) {
        if (activityListener == null) {
            throw new NullPointerException();
        }
        if (this.activityListeners != null) {
            this.activityListeners.remove(activityListener);
        }
        if (this.activityListeners.isEmpty()) {
            strongReferences.remove(this);
        }
    }

    boolean setActivityRequirementBindings(Set<IActivityRequirementBinding> activityRequirementBindings) {
        if (!Objects.equals(activityRequirementBindings = Util.safeCopy(activityRequirementBindings, IActivityRequirementBinding.class), this.activityRequirementBindings)) {
            this.activityRequirementBindings = activityRequirementBindings;
            this.activityRequirementBindingsAsArray = this.activityRequirementBindings.toArray(new IActivityRequirementBinding[this.activityRequirementBindings.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setActivityPatternBindings(Set<IActivityPatternBinding> activityPatternBindings) {
        if (!Objects.equals(activityPatternBindings = Util.safeCopy(activityPatternBindings, IActivityPatternBinding.class), this.activityPatternBindings)) {
            this.activityPatternBindings = activityPatternBindings;
            this.activityPatternBindingsAsArray = this.activityPatternBindings.toArray(new IActivityPatternBinding[this.activityPatternBindings.size()]);
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    void setExpression(Expression exp) {
        this.expression = exp;
    }

    boolean setDescription(String description) {
        if (!Objects.equals(description, this.description)) {
            this.description = description;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.activityRequirementBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.activityPatternBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.enabled);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    @Override
    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException();
        }
        return this.description;
    }

    @Override
    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    boolean setDefaultEnabled(boolean defaultEnabled) {
        if (defaultEnabled != this.defaultEnabled) {
            this.defaultEnabled = defaultEnabled;
            this.hashCode = HASH_INITIAL;
            this.string = null;
            return true;
        }
        return false;
    }
}

