/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.AbstractWorkingSetDialog;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;

public class SimpleWorkingSetSelectionDialog
extends AbstractWorkingSetDialog {
    private CheckboxTableViewer viewer;
    private final IWorkingSet[] initialSelection;

    public SimpleWorkingSetSelectionDialog(Shell shell, String[] workingSetTypeIds, IWorkingSet[] selectedWorkingSets, boolean canEdit) {
        super(shell, workingSetTypeIds, canEdit);
        this.initialSelection = selectedWorkingSets;
        this.setTitle(WorkbenchMessages.WorkingSetSelectionDialog_title_multiSelect);
        this.setMessage(WorkbenchMessages.WorkingSetSelectionDialog_message_multiSelect);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite viewerComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).layoutData((Object)new GridData(1808))).create((Widget)composite);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)viewerComposite, (int)2048);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.addFilter((ViewerFilter)new WorkingSetFilter(null));
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        this.viewer.setInput((Object)workingSets);
        this.viewer.setFilters(new ViewerFilter[]{new Filter()});
        this.viewer.addSelectionChangedListener(event -> this.handleSelectionChanged());
        this.viewer.setCheckedElements((Object[])this.initialSelection);
        GridData viewerData = new GridData(1808);
        viewerData.widthHint = this.convertWidthInCharsToPixels(50);
        this.viewer.getControl().setLayoutData((Object)viewerData);
        this.addModifyButtons(viewerComposite);
        this.addSelectionButtons(composite);
        this.availableWorkingSetsChanged();
        Dialog.applyDialogFont((Control)composite);
        viewerData.heightHint = this.viewer.getTable().getItemHeight() * Math.min(30, Math.max(10, workingSets.length));
        return composite;
    }

    protected void okPressed() {
        Object[] checked = this.viewer.getCheckedElements();
        IWorkingSet[] workingSets = new IWorkingSet[checked.length];
        System.arraycopy(checked, 0, workingSets, 0, checked.length);
        this.setSelection(workingSets);
        super.okPressed();
    }

    @Override
    protected List<IWorkingSet> getSelectedWorkingSets() {
        return this.viewer.getStructuredSelection().toList();
    }

    @Override
    protected void availableWorkingSetsChanged() {
        this.viewer.setInput((Object)PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        super.availableWorkingSetsChanged();
    }

    @Override
    protected void workingSetAdded(IWorkingSet addedSet) {
        this.viewer.setChecked((Object)addedSet, true);
        this.updateButtonAvailability();
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    @Override
    protected void selectAllSets() {
        this.viewer.setCheckedElements((Object[])PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        this.updateButtonAvailability();
    }

    @Override
    protected void deselectAllSets() {
        this.viewer.setCheckedElements(new Object[0]);
        this.updateButtonAvailability();
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.isCompatible((IWorkingSet)element);
        }

        private boolean isCompatible(IWorkingSet set) {
            if (set.isAggregateWorkingSet()) {
                return false;
            }
            if (!set.isVisible()) {
                return false;
            }
            if (!set.isEditable()) {
                return false;
            }
            Set<String> workingSetTypeIds = SimpleWorkingSetSelectionDialog.this.getSupportedWorkingSetIds();
            if (workingSetTypeIds == null) {
                return true;
            }
            for (String workingSetTypeId : workingSetTypeIds) {
                if (!workingSetTypeId.equals(set.getId())) continue;
                return true;
            }
            return false;
        }
    }
}

