/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.ActivityAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class InactivityDetector {
    private final ActivityAdapter activityAdapter = new ActivityAdapter(){

        @Override
        protected void handleActivity() {
            InactivityDetector.this.resetLastActivity();
            if (InactivityDetector.this.inactive) {
                InactivityDetector.this.inactive = false;
                InactivityDetector.this.handleInactivity(InactivityDetector.this.display, InactivityDetector.this.inactive);
            }
        }
    };
    private final int detectorInterval;
    private final int inactivityThreshold;
    private boolean inactive;
    private long lastActivity;
    private Display display;

    public InactivityDetector(int detectorInterval, int inactivityThreshold) {
        this.detectorInterval = detectorInterval;
        this.inactivityThreshold = inactivityThreshold;
        this.resetLastActivity();
    }

    public final boolean isInactive() {
        return this.inactive;
    }

    public final void monitor(final Control control) {
        final Display controlDisplay = control.getDisplay();
        controlDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    InactivityDetector.this.activityAdapter.attach(control);
                    if (InactivityDetector.this.display == null) {
                        InactivityDetector.this.display = controlDisplay;
                        InactivityDetector.this.display.timerExec(InactivityDetector.this.detectorInterval, new Runnable(){

                            @Override
                            public void run() {
                                if (!control.isDisposed()) {
                                    if (System.currentTimeMillis() - (this).InactivityDetector.this.lastActivity > (long)(this).InactivityDetector.this.inactivityThreshold && !(this).InactivityDetector.this.inactive) {
                                        (this).InactivityDetector.this.inactive = true;
                                        InactivityDetector.this.handleInactivity((this).InactivityDetector.this.display, (this).InactivityDetector.this.inactive);
                                    }
                                    if (!(this).InactivityDetector.this.display.isDisposed()) {
                                        (this).InactivityDetector.this.display.timerExec((this).InactivityDetector.this.detectorInterval, (Runnable)this);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    protected abstract void handleInactivity(Display var1, boolean var2);

    private void resetLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }
}

