/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.DirtyRegionQueue;
import org.eclipse.jface.text.reconciler.IReconciler;

public abstract class AbstractReconciler
implements IReconciler {
    private DirtyRegionQueue fDirtyRegionQueue;
    private BackgroundWorker fWorker;
    private Listener fListener;
    private int fDelay = 500;
    volatile boolean waitFinish;
    private boolean fIsIncrementalReconciler = true;
    private IProgressMonitor fProgressMonitor = new NullProgressMonitor();
    private boolean fIsAllowedToModifyDocument = true;
    private IDocument fDocument;
    private ITextViewer fViewer;

    protected abstract void process(DirtyRegion var1);

    protected abstract void reconcilerDocumentChanged(IDocument var1);

    protected AbstractReconciler() {
    }

    public void setDelay(int delay) {
        this.fDelay = delay;
    }

    public void setIsIncrementalReconciler(boolean isIncremental) {
        this.fIsIncrementalReconciler = isIncremental;
    }

    public void setIsAllowedToModifyDocument(boolean isAllowedToModify) {
        this.fIsAllowedToModifyDocument = isAllowedToModify;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        Assert.isLegal((monitor != null ? 1 : 0) != 0);
        this.fProgressMonitor = monitor;
    }

    protected boolean isIncrementalReconciler() {
        return this.fIsIncrementalReconciler;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fViewer = textViewer;
        AbstractReconciler abstractReconciler = this;
        synchronized (abstractReconciler) {
            if (this.fWorker != null) {
                return;
            }
            this.fWorker = new BackgroundWorker(this.getClass().getName());
        }
        this.fDirtyRegionQueue = new DirtyRegionQueue();
        this.fListener = new Listener();
        this.fViewer.addTextInputListener(this.fListener);
        IDocument document = textViewer.getDocument();
        if (document != null) {
            this.fListener.inputDocumentAboutToBeChanged(this.fDocument, document);
            this.fListener.inputDocumentChanged(this.fDocument, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        if (this.fListener != null) {
            this.fViewer.removeTextInputListener(this.fListener);
            if (this.fDocument != null) {
                this.fListener.inputDocumentAboutToBeChanged(this.fDocument, null);
                this.fListener.inputDocumentChanged(this.fDocument, null);
            }
            this.fListener = null;
            AbstractReconciler abstractReconciler = this;
            synchronized (abstractReconciler) {
                BackgroundWorker bt = this.fWorker;
                this.fWorker = null;
                bt.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDirtyRegion(DocumentEvent e) {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            if (e.getLength() == 0 && e.getText() != null) {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
            } else if (e.getText() == null || e.getText().isEmpty()) {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
            } else {
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
                this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
            }
        }
    }

    protected void aboutToBeReconciled() {
    }

    protected void aboutToWork() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalWaitForFinish() {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            this.waitFinish = true;
            this.fDirtyRegionQueue.notifyAll();
        }
    }

    private void informNotFinished() {
        this.waitFinish = false;
        this.aboutToWork();
    }

    private void aboutToBeReconciledInternal() {
        this.aboutToBeReconciled();
        this.informNotFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay() {
        DirtyRegionQueue dirtyRegionQueue = this.fDirtyRegionQueue;
        synchronized (dirtyRegionQueue) {
            if (this.waitFinish) {
                return;
            }
            try {
                this.fDirtyRegionQueue.wait(this.fDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void initialProcess() {
    }

    protected void forceReconciling() {
        if (this.fDocument != null) {
            if (!this.fWorker.isDirty() && this.fWorker.isAlive()) {
                this.aboutToBeReconciledInternal();
            }
            if (this.fWorker.isActive()) {
                this.fProgressMonitor.setCanceled(true);
            }
            if (this.fIsIncrementalReconciler) {
                DocumentEvent e = new DocumentEvent(this.fDocument, 0, this.fDocument.getLength(), this.fDocument.get());
                this.createDirtyRegion(e);
            }
            this.startReconciling();
        }
    }

    protected synchronized void startReconciling() {
        if (this.fWorker == null) {
            return;
        }
        this.fWorker.startReconciling();
    }

    protected void reconcilerReset() {
    }

    protected synchronized boolean isRunningInReconcilerThread() {
        if (this.fWorker == null) {
            return false;
        }
        return Thread.currentThread() == this.fWorker.fThread;
    }

    class BackgroundWorker
    implements Runnable {
        private boolean fCanceled;
        private boolean fReset;
        private boolean fIsDirty;
        private boolean fIsActive;
        private boolean fStarted;
        private String fName;
        private boolean fIsAlive;
        private volatile Thread fThread;

        public BackgroundWorker(String name) {
            this.fName = name;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public synchronized boolean isDirty() {
            return this.fIsDirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.fCanceled = true;
            IProgressMonitor pm = AbstractReconciler.this.fProgressMonitor;
            if (pm != null) {
                pm.setCanceled(true);
            }
            DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
            synchronized (dirtyRegionQueue) {
                AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendCallerWhileDirty() {
            boolean isDirty;
            AbstractReconciler.this.signalWaitForFinish();
            do {
                DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (dirtyRegionQueue) {
                    boolean bl = isDirty = AbstractReconciler.this.fDirtyRegionQueue.getSize() > 0;
                    if (isDirty) {
                        try {
                            AbstractReconciler.this.fDirtyRegionQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            } while (isDirty);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            if (AbstractReconciler.this.fDelay > 0) {
                Object object = this;
                synchronized (object) {
                    this.fIsDirty = true;
                    this.fReset = true;
                }
                object = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (object) {
                    AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
                }
            }
            Object object = this;
            synchronized (object) {
                this.fIsDirty = true;
            }
            object = AbstractReconciler.this.fDirtyRegionQueue;
            synchronized (object) {
                AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
            }
            AbstractReconciler.this.informNotFinished();
            AbstractReconciler.this.reconcilerReset();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[MONITOR], 1[TRYBLOCK], 16[WHILELOOP]], but top level block is 19[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        boolean isAlive() {
            return this.fIsAlive;
        }

        public void startReconciling() {
            if (!this.fStarted) {
                this.fIsAlive = true;
                this.fStarted = true;
                Job.createSystem((String)("Delayed Reconciler startup for " + this.fName), m -> {
                    this.fThread = Thread.currentThread();
                    AbstractReconciler.this.delay();
                    if (this.fCanceled) {
                        return Status.CANCEL_STATUS;
                    }
                    AbstractReconciler.this.initialProcess();
                    if (this.fCanceled) {
                        return Status.CANCEL_STATUS;
                    }
                    Thread thread = new Thread(this);
                    thread.setName(this.fName);
                    thread.setPriority(1);
                    thread.setDaemon(true);
                    this.fThread = thread;
                    thread.start();
                    return Status.OK_STATUS;
                }).schedule();
            } else {
                this.reset();
            }
        }
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            if (AbstractReconciler.this.fWorker.isActive() || !AbstractReconciler.this.fWorker.isDirty() && AbstractReconciler.this.fWorker.isAlive()) {
                if (!AbstractReconciler.this.fIsAllowedToModifyDocument && AbstractReconciler.this.isRunningInReconcilerThread()) {
                    throw new UnsupportedOperationException("The reconciler thread is not allowed to modify the document");
                }
                AbstractReconciler.this.aboutToBeReconciledInternal();
            }
            if (AbstractReconciler.this.fWorker.isActive() || AbstractReconciler.this.fWorker.isDirty() && AbstractReconciler.this.fWorker.isAlive()) {
                AbstractReconciler.this.fProgressMonitor.setCanceled(true);
            }
            if (AbstractReconciler.this.fIsIncrementalReconciler) {
                AbstractReconciler.this.createDirtyRegion(e);
            }
            AbstractReconciler.this.fWorker.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == AbstractReconciler.this.fDocument) {
                if (AbstractReconciler.this.fDocument != null) {
                    AbstractReconciler.this.fDocument.removeDocumentListener((IDocumentListener)this);
                }
                if (AbstractReconciler.this.fIsIncrementalReconciler) {
                    DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                    synchronized (dirtyRegionQueue) {
                        AbstractReconciler.this.fDirtyRegionQueue.purgeQueue();
                    }
                    if (AbstractReconciler.this.fDocument != null && AbstractReconciler.this.fDocument.getLength() > 0 && AbstractReconciler.this.fWorker.isDirty() && AbstractReconciler.this.fWorker.isAlive()) {
                        DocumentEvent e = new DocumentEvent(AbstractReconciler.this.fDocument, 0, AbstractReconciler.this.fDocument.getLength(), "");
                        AbstractReconciler.this.createDirtyRegion(e);
                        AbstractReconciler.this.fWorker.reset();
                        AbstractReconciler.this.fWorker.suspendCallerWhileDirty();
                    }
                }
                AbstractReconciler.this.fDocument = null;
            }
        }

        @Override
        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            AbstractReconciler.this.fDocument = newInput;
            if (AbstractReconciler.this.fDocument == null) {
                return;
            }
            AbstractReconciler.this.reconcilerDocumentChanged(AbstractReconciler.this.fDocument);
            AbstractReconciler.this.fDocument.addDocumentListener((IDocumentListener)this);
            if (!AbstractReconciler.this.fWorker.isDirty()) {
                AbstractReconciler.this.aboutToBeReconciledInternal();
            }
            AbstractReconciler.this.startReconciling();
        }
    }
}

