/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ClusterTransaction
extends BaseTransaction {
    TransactionBroker[] transactionBrokers;

    public ClusterTransaction() {
        super(3);
    }

    public ClusterTransaction(TransactionUID id, TransactionState ts, TransactionWork txnWork, TransactionBroker[] tbas) {
        this();
        this.transactionDetails.setTid(id);
        this.transactionDetails.setXid(ts.getXid());
        this.transactionDetails.setState(5);
        this.setTransactionWork(txnWork);
        this.setTransactionState(ts);
        this.setTransactionBrokers(tbas);
    }

    @Override
    public void readData(DataInputStream dis) throws IOException, BrokerException {
        this.transactionDetails.readContent(dis);
        if (this.transactionWork == null) {
            this.transactionWork = new TransactionWork();
        }
        this.transactionWork.readWork(dis);
    }

    @Override
    public void readObjects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.transactionState = (TransactionState)ois.readObject();
        this.transactionBrokers = (TransactionBroker[])ois.readObject();
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        this.transactionDetails.writeContent(dos);
        this.transactionWork.writeWork(dos);
    }

    @Override
    public void writeObjects(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.transactionState);
        oos.writeObject(this.transactionBrokers);
    }

    public TransactionBroker[] getTransactionBrokers() {
        return this.transactionBrokers;
    }

    public void setTransactionBrokers(TransactionBroker[] transactionBrokers) {
        this.transactionBrokers = transactionBrokers;
    }

    @Override
    String getPrefix() {
        return "ClusterTransaction: " + Thread.currentThread().getName() + " " + this.getTid();
    }
}

