/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import java.io.IOException;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.common.ui.editmodel.IEditModelListener;
import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.common.ui.editmodel.SynchronizationHandler;
import org.eclipse.bpel.common.ui.editmodel.SynchronizationManager;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;

public class EditModelClient {
    private ResourceInfo primaryResourceInfo;
    private EditModel editModel;
    private IEditModelListener modelListener;
    private SynchronizationManager manager;
    private IEditorPart editor;

    public EditModelClient(IEditorPart editor, IEditModelListener modelListener) {
        this.editor = editor;
        this.modelListener = modelListener;
    }

    public void loadPrimaryResource(IFile file, Map loadOptions) throws RuntimeException {
        this.editModel = this.getSharedResourceSet(file);
        ((BPELResourceSetImpl)this.editModel.getResourceSet()).setLoadOptions(loadOptions);
        try {
            Synchronizer handler = new Synchronizer();
            if (this.getCommandStack() == null) {
                EditModelCommandStack commandStack = this.createCommandStack();
                this.editModel.setCommandStack(commandStack);
            }
            this.primaryResourceInfo = this.editModel.getResourceInfo(file);
            if (loadOptions != null) {
                this.primaryResourceInfo.setLoadOptions(loadOptions);
            }
            this.getEditModel().addListener(this.modelListener);
            this.manager = new SynchronizationManager(this.editor, this.editModel, handler);
        }
        catch (RuntimeException ex) {
            if (this.editModel != null) {
                this.editModel.release();
            }
            throw ex;
        }
    }

    protected EditModel getSharedResourceSet(IFile file) {
        return EditModel.getEditModel((IResource)file);
    }

    protected EditModelCommandStack createCommandStack() {
        return new EditModelCommandStack();
    }

    public EditModelCommandStack getCommandStack() {
        return this.editModel.getCommandStack();
    }

    public EditModel getEditModel() {
        return this.editModel;
    }

    public ResourceInfo getPrimaryResourceInfo() {
        return this.primaryResourceInfo;
    }

    public void dispose() {
        this.getEditModel().removeListener(this.modelListener);
        this.editModel.releaseReference(this.primaryResourceInfo);
        this.editModel.release();
    }

    public boolean saveAll(IProgressMonitor progressMonitor) {
        return this.editModel.saveAll(progressMonitor);
    }

    public boolean savePrimaryResourceAs(IFile savedFile, IProgressMonitor progressMonitor) {
        return this.editModel.savePrimaryResourceAs(this.primaryResourceInfo, savedFile, progressMonitor);
    }

    void close() {
        this.editor.getSite().getPage().closeEditor(this.editor, false);
    }

    private class Synchronizer
    implements SynchronizationHandler {
        private Synchronizer() {
        }

        @Override
        public void closeEditor() {
            EditModelClient.this.close();
        }

        @Override
        public boolean saveFileAs(ResourceInfo resourceInfo, IFile file) throws CoreException, IOException {
            if (resourceInfo.equals(EditModelClient.this.primaryResourceInfo)) {
                return EditModelClient.this.savePrimaryResourceAs(file, null);
            }
            resourceInfo.saveAs(file);
            return true;
        }

        @Override
        public void refresh(ResourceInfo resourceInfo) {
            try {
                resourceInfo.refresh();
            }
            catch (Exception e) {
                CommonUIPlugin.log(e);
            }
            EditModelClient.this.getCommandStack().flush();
        }
    }
}

