/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class ForEachValidator
extends CActivityValidator {
    protected String fCounterName;
    protected String fParallel;

    @Override
    protected void start() {
        super.start();
    }

    @ARule(desc="Check parallel attribute in forEach activity.", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckParallel_1() {
        this.fParallel = this.getAttribute(this.mNode, AT_PARALLEL, 1, Filters.BOOLEAN_FILTER, true);
        if (ForEachValidator.isEmpty(this.fParallel)) {
            this.fParallel = "no";
        }
    }

    @ARule(sa=0, desc="Check the NCName of the forEach activity counter.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckCounterName_2() {
        this.fCounterName = this.mNode.getAttribute(AT_COUNTER_NAME);
        this.checkNCName(this.mNode, this.fCounterName, AT_COUNTER_NAME);
    }

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_START_COUNTER_VALUE, 1, 1);
        this.checkChild(ND_FINAL_COUNTER_VALUE, 1, 1);
        this.checkChild(ND_COMPLETION_CONDITION, 0, 1);
        this.checkChild(ND_SCOPE, 1, 1);
    }
}

