/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2FeatureProvider;
import org.eclipse.bpmn2.modeler.core.features.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class CustomElementFeatureContainer
implements ICustomElementFeatureContainer {
    protected String id;
    protected CustomTaskDescriptor customTaskDescriptor;
    protected IFeatureContainer featureContainerDelegate = null;
    protected IBpmn2FeatureProvider fp;

    @Override
    public String getDescription() {
        if (this.customTaskDescriptor != null) {
            return this.customTaskDescriptor.getName();
        }
        return Messages.CustomElementFeatureContainer_Description;
    }

    protected IFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        EClass eClass = (EClass)ModelDecorator.findEClassifier(this.customTaskDescriptor.getRuntime().getModelDescriptor().getEPackage(), this.customTaskDescriptor.getType());
        return ((IBpmn2FeatureProvider)fp).getFeatureContainer(eClass.getInstanceClass());
    }

    protected IFeatureContainer getFeatureContainer(IFeatureProvider fp) {
        if (this.featureContainerDelegate == null) {
            this.featureContainerDelegate = this.createFeatureContainer(fp);
        }
        return this.featureContainerDelegate;
    }

    @Override
    public Object getApplyObject(IContext context) {
        String id = CustomElementFeatureContainer.getId(context);
        if (id == null || !this.id.equals(id)) {
            return null;
        }
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            return BusinessObjectUtil.getBusinessObjectForPictogramElement(pe);
        }
        return null;
    }

    @Override
    public boolean canApplyTo(Object o) {
        boolean b1 = o instanceof BaseElement;
        boolean b2 = o.getClass().isAssignableFrom(BaseElement.class);
        return b1 || b2;
    }

    @Override
    public boolean isAvailable(IFeatureProvider fp) {
        ModelEnablements me;
        DiagramEditor editor = (DiagramEditor)fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        if (editor != null && (me = (ModelEnablements)editor.getAdapter(ModelEnablements.class)) != null) {
            return me.isEnabled(this.customTaskDescriptor.getType());
        }
        return true;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static void setId(IContext context, String id) {
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            FeatureSupport.setPropertyValue((PropertyContainer)pe, "custom.element.id", id);
        } else {
            context.putProperty((Object)"custom.element.id", (Object)id);
        }
    }

    public static String getId(IContext context) {
        PictogramElement pe;
        Object newObject;
        Object id = null;
        if (context instanceof IAddContext && (newObject = ((IAddContext)context).getNewObject()) instanceof EObject) {
            EObject eObject = (EObject)newObject;
            TargetRuntime rt = TargetRuntime.getRuntime(eObject);
            for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                id = ctd.getFeatureContainer().getId(eObject);
                if (!ctd.getId().equals(id)) continue;
                context.putProperty((Object)"custom.element.id", id);
                return (String)id;
            }
        }
        if (context instanceof IPictogramElementContext) {
            pe = ((IPictogramElementContext)context).getPictogramElement();
            id = FeatureSupport.getPropertyValue((PropertyContainer)pe, "custom.element.id");
        } else if (context instanceof ICustomContext) {
            PictogramElement[] pictogramElementArray = ((ICustomContext)context).getPictogramElements();
            int n = pictogramElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                pe = pictogramElementArray[n2];
                id = FeatureSupport.getPropertyValue((PropertyContainer)pe, "custom.element.id");
                if (id == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (context instanceof IReconnectionContext) {
            pe = ((IReconnectionContext)context).getConnection();
            id = FeatureSupport.getPropertyValue((PropertyContainer)pe, "custom.element.id");
        } else {
            id = context.getProperty((Object)"custom.element.id");
        }
        return id;
    }

    public static String findId(EObject eObject) {
        TargetRuntime rt = TargetRuntime.getRuntime(eObject);
        if (rt != null) {
            for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                String id = ctd.getFeatureContainer().getId(eObject);
                if (!ctd.getId().equals(id)) continue;
                return id;
            }
        }
        return null;
    }

    @Override
    public String getId(EObject object) {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setCustomTaskDescriptor(CustomTaskDescriptor customTaskDescriptor) {
        this.customTaskDescriptor = customTaskDescriptor;
    }

    @Override
    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddCustomElementFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getUpdateFeature(fp);
    }

    @Override
    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDirectEditingFeature(fp);
    }

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getLayoutFeature(fp);
    }

    @Override
    public IRemoveFeature getRemoveFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getRemoveFeature(fp);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDeleteFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getCustomFeatures(fp);
    }

    public class AddCustomElementFeature
    extends AbstractBpmn2AddFeature<BaseElement> {
        protected AbstractBpmn2AddFeature<BaseElement> addFeatureDelegate;

        public AddCustomElementFeature(IFeatureProvider fp) {
            super(fp);
            this.addFeatureDelegate = (AbstractBpmn2AddFeature)CustomElementFeatureContainer.this.getFeatureContainer(fp).getAddFeature(fp);
            Assert.isNotNull(this.addFeatureDelegate);
        }

        public PictogramElement add(IAddContext context) {
            String icon;
            PictogramElement pe = this.addFeatureDelegate.add(context);
            if (pe != null) {
                FeatureSupport.setPropertyValue((PropertyContainer)pe, "custom.element.id", CustomElementFeatureContainer.this.getId());
            }
            if ((icon = CustomElementFeatureContainer.this.customTaskDescriptor.getIcon()) != null && pe instanceof ContainerShape) {
                boolean addImage = true;
                ContainerShape containerShape = (ContainerShape)pe;
                GraphicsAlgorithm ga = (GraphicsAlgorithm)AbstractBpmn2AddFeature.getGraphicsAlgorithm(containerShape);
                for (PictogramElement child : containerShape.getChildren()) {
                    if (!(child.getGraphicsAlgorithm() instanceof Image)) continue;
                    addImage = false;
                    break;
                }
                if (ga != null) {
                    for (GraphicsAlgorithm g : ga.getGraphicsAlgorithmChildren()) {
                        if (!(g instanceof Image)) continue;
                        addImage = false;
                        break;
                    }
                } else {
                    addImage = false;
                }
                if (addImage) {
                    Image img = CustomTaskImageProvider.createImage(CustomElementFeatureContainer.this.customTaskDescriptor, (GraphicsAlgorithmContainer)ga, icon, 24, 24);
                    Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)img, 2, 2, 24, 24);
                }
            }
            return pe;
        }

        @Override
        public BaseElement getBusinessObject(IAddContext context) {
            return this.addFeatureDelegate.getBusinessObject(context);
        }

        @Override
        public void putBusinessObject(IAddContext context, BaseElement businessObject) {
            this.addFeatureDelegate.putBusinessObject(context, businessObject);
        }

        @Override
        public void postExecute(IExecutionInfo executionInfo) {
            this.addFeatureDelegate.postExecute(executionInfo);
        }

        public boolean canAdd(IAddContext context) {
            return this.addFeatureDelegate.canAdd(context);
        }

        @Override
        public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
            return this.addFeatureDelegate.getAddLabelFeature(fp);
        }

        @Override
        public int getHeight(IAddContext context) {
            return this.addFeatureDelegate.getHeight(context);
        }

        @Override
        public int getWidth(IAddContext context) {
            return this.addFeatureDelegate.getWidth(context);
        }

        @Override
        public Class getBusinessObjectType() {
            return this.addFeatureDelegate.getBusinessObjectType();
        }
    }
}

