/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;

class AggregateInitialization {
    private ICPPEvaluation[] fInitializers;
    private int fIndex = 0;

    public static Cost check(IType target, EvalInitList list) throws DOMException {
        return new AggregateInitialization().checkImpl(target, list);
    }

    private AggregateInitialization() {
    }

    private Cost checkImpl(IType target, EvalInitList list) throws DOMException {
        this.fInitializers = list.getClauses();
        this.fIndex = 0;
        Cost worstCost = new Cost(list.getType(), target, Cost.Rank.IDENTITY);
        Cost cost = this.checkInitializationOfElements(target, worstCost);
        if (!cost.converts()) {
            return cost;
        }
        if (this.fIndex < this.fInitializers.length) {
            return Cost.NO_CONVERSION;
        }
        return worstCost;
    }

    private Cost checkElement(IType type, IValue initialValue, Cost worstCost) throws DOMException {
        IType nestedType = SemanticUtil.getNestedType(type, 1);
        if (this.fIndex >= this.fInitializers.length) {
            return this.checkInitializationFromDefaultMemberInitializer(nestedType, initialValue, worstCost);
        }
        worstCost = new Cost(this.fInitializers[this.fIndex].getType(), nestedType, Cost.Rank.IDENTITY);
        if (this.fInitializers[this.fIndex].isInitializerList() || !AggregateInitialization.isAggregate(nestedType)) {
            ICPPEvaluation initializer = this.fInitializers[this.fIndex];
            ++this.fIndex;
            Cost cost = Conversions.checkImplicitConversionSequence(nestedType, initializer.getType(), initializer.getValueCategory(), Conversions.UDCMode.ALLOWED, Conversions.Context.ORDINARY);
            if (!cost.converts()) {
                return cost;
            }
            if (!(initializer instanceof EvalInitList) && cost.isNarrowingConversion()) {
                return Cost.NO_CONVERSION;
            }
            if (cost.compareTo(worstCost) > 0) {
                worstCost = cost;
            }
        } else {
            Cost cost = this.checkInitializationOfElements(nestedType, worstCost);
            if (!cost.converts()) {
                return cost;
            }
            if (cost.compareTo(worstCost) > 0) {
                worstCost = cost;
            }
        }
        return worstCost;
    }

    private Cost checkInitializationOfElements(IType type, Cost worstCost) throws DOMException {
        block7: {
            IArrayType arrayType;
            Number arraySize;
            block6: {
                ICPPField[] fields;
                if (!(type instanceof ICPPClassType) || !TypeTraits.isAggregateClass((ICPPClassType)type)) break block6;
                ICPPField[] iCPPFieldArray = fields = AggregateInitialization.getFieldsForAggregateInitialization((ICPPClassType)type);
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPField field = iCPPFieldArray[n2];
                    Cost cost = this.checkElement(field.getType(), field.getInitialValue(), worstCost);
                    if (!cost.converts()) {
                        return cost;
                    }
                    if (cost.compareTo(worstCost) > 0) {
                        worstCost = cost;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!(type instanceof IArrayType) || (arraySize = (arrayType = (IArrayType)type).getSize().numberValue()) == null) break block7;
            long i = 0L;
            while (i < arraySize.longValue()) {
                Cost cost = this.checkElement(arrayType.getType(), null, worstCost);
                if (!cost.converts()) {
                    return cost;
                }
                if (cost.compareTo(worstCost) > 0) {
                    worstCost = cost;
                }
                ++i;
            }
        }
        return worstCost;
    }

    private Cost checkInitializationFromDefaultMemberInitializer(IType type, IValue initialValue, Cost worstCost) throws DOMException {
        if (initialValue != null) {
            return worstCost;
        }
        IType fieldType = SemanticUtil.getNestedType(type, 1);
        if (fieldType instanceof ICPPReferenceType) {
            return Cost.NO_CONVERSION;
        }
        EvalInitList emptyInit = new EvalInitList(ICPPEvaluation.EMPTY_ARRAY, CPPSemantics.getCurrentLookupPoint());
        Cost cost = Conversions.listInitializationSequence(emptyInit, fieldType, Conversions.UDCMode.ALLOWED, false);
        return cost;
    }

    private static boolean isAggregate(IType type) {
        return type instanceof ICPPClassType && TypeTraits.isAggregateClass((ICPPClassType)type) || type instanceof IArrayType;
    }

    private static ICPPField[] getFieldsForAggregateInitialization(ICPPClassType targetClass) {
        ICPPField[] fields;
        ICPPField[] result = fields = targetClass.getDeclaredFields();
        int j = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isStatic()) {
                if (fields == result) {
                    result = new ICPPField[fields.length - 1];
                    System.arraycopy(fields, 0, result, 0, i);
                }
            } else if (fields != result) {
                result[j] = fields[i];
                ++j;
            }
            ++i;
        }
        return ArrayUtil.trim(result);
    }
}

