/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryDescriptorNameComparator;

public class CategoryUtils {
    public static CategoryDescriptor[] getOrderedRootCategories() {
        CategoryDescriptor[] roots = CategoryDescriptor.getRootCategories();
        if (roots != null && roots.length > 0) {
            Arrays.sort(roots, new CategoryDescriptorNameComparator());
            return roots;
        }
        return null;
    }

    public static CategoryDescriptor[] getOrderedChildCategories(String id) {
        CategoryDescriptor cdById = CategoryDescriptor.getCategoryDescriptor((String)id);
        if (cdById != null) {
            List childList = cdById.getChildCategories();
            if (childList != null && childList.size() > 0) {
                CategoryDescriptor[] children = childList.toArray(new CategoryDescriptor[childList.size()]);
                Arrays.sort(children, new CategoryDescriptorNameComparator());
                return children;
            }
            return new CategoryDescriptor[0];
        }
        return null;
    }

    public static CategoryDescriptor getCategoryDescriptorByName(String name) {
        CategoryDescriptor[] descriptors = CategoryDescriptor.getCategoryDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(name)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }
}

