/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.providers.decorators;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl.AbstractDecorationService;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jface.viewers.IDecoration;

public class ParameterDecorationService
extends AbstractDecorationService {
    private DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    private static final String BLANK = "";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof Parameter) {
            this.decorate((Parameter)element, decoration);
        }
    }

    private void decorate(Parameter parameter, IDecoration decoration) {
        String dataType = this.getDataType(parameter);
        if (dataType != null && dataType.trim().length() > 0) {
            dataType = " [" + dataType + "]";
        }
        decoration.addSuffix(dataType);
    }

    public String getDataType(Parameter parameter) {
        Database database;
        Catalog catalog;
        Schema schema;
        DataType datatype = parameter.getDataType();
        Routine routine = parameter.getRoutine();
        if (routine != null && (schema = routine.getSchema()) != null && ((catalog = schema.getCatalog()) != null && (database = catalog.getDatabase()) != null || (database = schema.getDatabase()) != null)) {
            DatabaseDefinition definition = this.dbRegistry.getDefinition(database);
            if (datatype != null) {
                if (datatype instanceof PredefinedDataType) {
                    return definition.getPredefinedDataTypeFormattedName((PredefinedDataType)datatype);
                }
                return datatype.getName();
            }
        }
        return BLANK;
    }
}

