/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ListElementChooserComposite
extends Composite {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final String LABEL = "Label";
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int NUM_COLUMNS_3 = 3;
    private org.eclipse.swt.widgets.List m_listOne;
    private org.eclipse.swt.widgets.List m_listTwo;
    private Button m_selectionOneToTwoButton;
    private Button m_allOneToTwoButton;
    private Button m_selectionTwoToOneButton;
    private Button m_allTwoToOneButton;
    private String[] m_listOneSelection;
    private String[] m_listTwoSelection;
    private Object[] m_disabledButtonContents;
    private Object[] m_buttonContents;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();

    public ListElementChooserComposite(Composite parent, String listOneLabel, List listOneList, String listTwoLabel, List listTwoList, int lineNumber, String[] buttonTexts, String[] buttonToolTips, int style) {
        super(parent, 0);
        this.m_disabledButtonContents = buttonTexts;
        this.m_buttonContents = buttonTexts;
        this.createControl(listOneLabel, listOneList, listTwoLabel, listTwoList, lineNumber, buttonToolTips, style);
    }

    public ListElementChooserComposite(Composite parent, String listOneLabel, List listOneList, String listTwoLabel, List listTwoList, int lineNumber, Image[] buttonImages, Image[] disabledButtonImages, String[] buttonToolTips, int style) {
        super(parent, 0);
        this.m_disabledButtonContents = disabledButtonImages;
        this.m_buttonContents = buttonImages;
        this.createControl(listOneLabel, listOneList, listTwoLabel, listTwoList, lineNumber, buttonToolTips, style);
    }

    private void createControl(String listOneLabel, List listOneList, String listTwoLabel, List listTwoList, int lineNumber, String[] buttonToolTips, int style) {
        if (style == 0) {
            this.createHorizontalLayout(listOneLabel, listTwoLabel, lineNumber, buttonToolTips, style);
        } else {
            ListElementChooserComposite composite = this;
            GridLayout compositeLayout = new GridLayout();
            compositeLayout.numColumns = 3;
            compositeLayout.marginHeight = 0;
            compositeLayout.marginWidth = 0;
            composite.setLayout((Layout)compositeLayout);
            GridData compositeData = new GridData();
            compositeData.horizontalAlignment = 4;
            compositeData.grabExcessHorizontalSpace = true;
            composite.setLayoutData(compositeData);
            this.createVerticalLayout(composite, listOneLabel, listTwoLabel, lineNumber, buttonToolTips, style);
        }
        this.initFields(listOneList, listTwoList);
        this.addListener();
        this.checkButtons();
    }

    private void createVerticalLayout(Composite parent, String listOneLabel, String listTwoLabel, int lineNumber, String[] buttonToolTips, int style) {
        Composite compositeLeft = this.createComposite(parent, 1, 4, true);
        Composite compositeMiddle = this.createComposite(parent, 1, 4, false);
        Composite compositeRight = this.createComposite(parent, 1, 4, true);
        this.m_listOne = this.createListField(compositeLeft, listOneLabel, lineNumber);
        this.m_listOne.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.createShiftButtons(style, compositeMiddle, buttonToolTips);
        this.m_listTwo = this.createListField(compositeRight, listTwoLabel, lineNumber);
        this.m_listTwo.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void createHorizontalLayout(String listOneLabel, String listTwoLabel, int lineNumber, String[] buttonToolTips, int style) {
        ListElementChooserComposite composite = this;
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = false;
        compositeData.verticalAlignment = 1;
        composite.setLayoutData(compositeData);
        this.m_listOne = this.createListField(composite, listOneLabel, lineNumber);
        this.m_listOne.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.createShiftButtons(style, composite, buttonToolTips);
        this.m_listTwo = this.createListField(composite, listTwoLabel, lineNumber);
        this.m_listTwo.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    protected void initFields(List listOneList, List listTwoList) {
        this.fillLists(listOneList, listTwoList);
    }

    private void createShiftButtons(int style, Composite parent, String[] buttonToolTips) {
        if (style == 0) {
            this.createComposite(parent, 1, 1, false);
            Composite composite = this.createComposite(parent, 2, 4, true);
            Composite leftComposite = this.createComposite(composite, 2, 4, true);
            Composite rightComposite = this.createComposite(composite, 2, 4, true);
            this.m_selectionOneToTwoButton = new Button(leftComposite, 8);
            this.m_allOneToTwoButton = new Button(leftComposite, 8);
            this.m_selectionTwoToOneButton = new Button(rightComposite, 8);
            this.m_allTwoToOneButton = new Button(rightComposite, 8);
        } else {
            this.createLabel(parent, "");
            this.m_selectionOneToTwoButton = new Button(parent, 8);
            this.m_allOneToTwoButton = new Button(parent, 8);
            this.createLabel(parent, "");
            this.m_selectionTwoToOneButton = new Button(parent, 8);
            this.m_allTwoToOneButton = new Button(parent, 8);
        }
        GridData selectionOneToTwoGridData = new GridData();
        selectionOneToTwoGridData.horizontalAlignment = 4;
        if (style == 0) {
            selectionOneToTwoGridData.horizontalAlignment = 3;
        }
        selectionOneToTwoGridData.grabExcessHorizontalSpace = true;
        this.m_selectionOneToTwoButton.setLayoutData((Object)selectionOneToTwoGridData);
        this.m_selectionOneToTwoButton.setImage((Image)this.m_disabledButtonContents[0]);
        this.m_selectionOneToTwoButton.setEnabled(false);
        GridData allOneToTwoGridData = new GridData();
        allOneToTwoGridData.horizontalAlignment = 4;
        if (style == 0) {
            allOneToTwoGridData.horizontalAlignment = 1;
        }
        allOneToTwoGridData.grabExcessHorizontalSpace = true;
        this.m_allOneToTwoButton.setLayoutData((Object)allOneToTwoGridData);
        this.m_allOneToTwoButton.setImage((Image)this.m_disabledButtonContents[1]);
        this.m_allOneToTwoButton.setEnabled(false);
        GridData selectionTwoToOneGridData = new GridData();
        selectionTwoToOneGridData.horizontalAlignment = 4;
        if (style == 0) {
            selectionTwoToOneGridData.horizontalAlignment = 3;
        }
        selectionTwoToOneGridData.grabExcessHorizontalSpace = true;
        this.m_selectionTwoToOneButton.setLayoutData((Object)selectionTwoToOneGridData);
        this.m_selectionTwoToOneButton.setImage((Image)this.m_disabledButtonContents[2]);
        this.m_selectionTwoToOneButton.setEnabled(false);
        GridData allTwoToOneGridData = new GridData();
        allTwoToOneGridData.horizontalAlignment = 4;
        if (style == 0) {
            allTwoToOneGridData.horizontalAlignment = 1;
        }
        allTwoToOneGridData.grabExcessHorizontalSpace = true;
        this.m_allTwoToOneButton.setLayoutData((Object)allTwoToOneGridData);
        this.m_allTwoToOneButton.setImage((Image)this.m_disabledButtonContents[3]);
        this.m_allTwoToOneButton.setEnabled(false);
        if (this.m_buttonContents instanceof Image[]) {
            this.m_selectionOneToTwoButton.setImage((Image)this.m_buttonContents[0]);
            this.m_allOneToTwoButton.setImage((Image)this.m_buttonContents[1]);
            this.m_selectionTwoToOneButton.setImage((Image)this.m_buttonContents[2]);
            this.m_allTwoToOneButton.setImage((Image)this.m_buttonContents[3]);
        } else {
            this.m_selectionOneToTwoButton.setText((String)this.m_buttonContents[0]);
            this.m_allOneToTwoButton.setText((String)this.m_buttonContents[1]);
            this.m_selectionTwoToOneButton.setText((String)this.m_buttonContents[2]);
            this.m_allTwoToOneButton.setText((String)this.m_buttonContents[3]);
        }
        this.m_selectionOneToTwoButton.setToolTipText(buttonToolTips[0]);
        this.m_allOneToTwoButton.setToolTipText(buttonToolTips[1]);
        this.m_selectionTwoToOneButton.setToolTipText(buttonToolTips[2]);
        this.m_allTwoToOneButton.setToolTipText(buttonToolTips[3]);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private org.eclipse.swt.widgets.List createListField(Composite composite, String labelText, int lines) {
        Composite leftComposite = this.createComposite(composite, 2, 1, false);
        Composite rightComposite = this.createComposite(composite, 1, 4, true);
        Label label = this.createLabel(leftComposite, labelText);
        org.eclipse.swt.widgets.List listField = new org.eclipse.swt.widgets.List(rightComposite, 2818);
        listField.setData(LABEL, (Object)label);
        GridData listGridData = new GridData();
        listGridData.horizontalAlignment = 4;
        listGridData.horizontalSpan = 1;
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)listField), (int)lines);
        listField.setLayoutData((Object)listGridData);
        return listField;
    }

    protected void fillLists(List listOneList, List listTwoList) {
        Object[] listOne = listOneList.toArray();
        Object[] listTwo = listTwoList.toArray();
        Arrays.sort(listOne);
        Arrays.sort(listTwo);
        int i = 0;
        while (i < listOne.length) {
            boolean isInListTwo = false;
            Object[] objectArray = listTwo;
            int n = listTwo.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (listOne[i].toString().equals(object.toString())) {
                    isInListTwo = true;
                    break;
                }
                ++n2;
            }
            if (!isInListTwo) {
                this.m_listOne.add(listOne[i].toString());
            }
            ++i;
        }
        i = 0;
        while (i < listTwo.length) {
            this.m_listTwo.add(listTwo[i].toString());
            ++i;
        }
    }

    protected void handleSelectionOneToTwoButtonEvent() {
        this.m_listOneSelection = this.m_listOne.getSelection();
        Object[] selection = this.m_listOne.getSelection();
        int i = 0;
        while (i < selection.length) {
            this.m_listTwo.add(selection[i]);
            this.m_listOne.remove((String)selection[i]);
            ++i;
        }
        selection = this.m_listTwo.getItems();
        Arrays.sort(selection);
        this.m_listTwo.removeAll();
        this.m_listTwo.setItems((String[])selection);
        this.checkButtons();
    }

    protected void handleSelectionTwoToOneButtonEvent() {
        this.m_listTwoSelection = this.m_listTwo.getSelection();
        Object[] selection = this.m_listTwo.getSelection();
        int i = 0;
        while (i < selection.length) {
            this.m_listOne.add(selection[i]);
            this.m_listTwo.remove((String)selection[i]);
            ++i;
        }
        selection = this.m_listOne.getItems();
        Arrays.sort(selection);
        this.m_listOne.removeAll();
        this.m_listOne.setItems((String[])selection);
        this.checkButtons();
    }

    protected void handleAllOneToTwoButtonEvent() {
        while (this.m_listOne.getItemCount() > 0) {
            this.m_listTwo.add(this.m_listOne.getItem(0));
            this.m_listOne.remove(0);
        }
        Object[] selection = this.m_listTwo.getItems();
        Arrays.sort(selection);
        this.m_listTwo.removeAll();
        this.m_listTwo.setItems((String[])selection);
        this.checkButtons();
    }

    protected void handleAllTwoToOneButtonEvent() {
        while (this.m_listTwo.getItemCount() > 0) {
            this.m_listOne.add(this.m_listTwo.getItem(0));
            this.m_listTwo.remove(0);
        }
        Object[] selection = this.m_listOne.getItems();
        Arrays.sort(selection);
        this.m_listOne.removeAll();
        this.m_listOne.setItems((String[])selection);
        this.checkButtons();
    }

    public void checkButtons() {
        if (this.m_listOne.getItemCount() == 0) {
            this.m_selectionOneToTwoButton.setImage((Image)this.m_disabledButtonContents[0]);
            this.m_selectionOneToTwoButton.setEnabled(false);
            this.m_allOneToTwoButton.setImage((Image)this.m_disabledButtonContents[1]);
            this.m_allOneToTwoButton.setEnabled(false);
        } else {
            this.m_selectionOneToTwoButton.setImage((Image)this.m_buttonContents[0]);
            this.m_selectionOneToTwoButton.setEnabled(true);
            this.m_allOneToTwoButton.setImage((Image)this.m_buttonContents[1]);
            this.m_allOneToTwoButton.setEnabled(true);
        }
        if (this.m_listTwo.getItemCount() == 0) {
            this.m_selectionTwoToOneButton.setImage((Image)this.m_disabledButtonContents[2]);
            this.m_selectionTwoToOneButton.setEnabled(false);
            this.m_allTwoToOneButton.setImage((Image)this.m_disabledButtonContents[3]);
            this.m_allTwoToOneButton.setEnabled(false);
        } else {
            this.m_selectionTwoToOneButton.setImage((Image)this.m_buttonContents[2]);
            this.m_selectionTwoToOneButton.setEnabled(true);
            this.m_allTwoToOneButton.setImage((Image)this.m_buttonContents[3]);
            this.m_allTwoToOneButton.setEnabled(true);
        }
        if (this.m_listTwo.getSelectionCount() == 0) {
            this.m_selectionTwoToOneButton.setImage((Image)this.m_disabledButtonContents[2]);
            this.m_selectionTwoToOneButton.setEnabled(false);
        }
        if (this.m_listOne.getSelectionCount() == 0) {
            this.m_selectionOneToTwoButton.setImage((Image)this.m_disabledButtonContents[0]);
            this.m_selectionOneToTwoButton.setEnabled(false);
        }
    }

    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    private void addListener() {
        this.m_selectionTwoToOneButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_selectionOneToTwoButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allOneToTwoButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allTwoToOneButton.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void removeListener() {
        this.m_selectionOneToTwoButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_selectionTwoToOneButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allOneToTwoButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allTwoToOneButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_listOne.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_listTwo.removeSelectionListener((SelectionListener)this.m_selectionListener);
    }

    public Button getAllOneToTwoButton() {
        return this.m_allOneToTwoButton;
    }

    public Button getAllTwoToOneButton() {
        return this.m_allTwoToOneButton;
    }

    public org.eclipse.swt.widgets.List getListOne() {
        return this.m_listOne;
    }

    public org.eclipse.swt.widgets.List getListTwo() {
        return this.m_listTwo;
    }

    public Button getSelectionOneToTwoButton() {
        return this.m_selectionOneToTwoButton;
    }

    public Button getSelectionTwoToOneButton() {
        return this.m_selectionTwoToOneButton;
    }

    public Label getListOneLabel() {
        return (Label)this.m_listOne.getData(LABEL);
    }

    public Label getListTwoLabel() {
        return (Label)this.m_listTwo.getData(LABEL);
    }

    public String[] getListOneSelection() {
        return this.m_listOneSelection;
    }

    public String[] getListTwoSelection() {
        return this.m_listTwoSelection;
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ListElementChooserComposite.this.m_selectionOneToTwoButton)) {
                ListElementChooserComposite.this.handleSelectionOneToTwoButtonEvent();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_selectionTwoToOneButton)) {
                ListElementChooserComposite.this.handleSelectionTwoToOneButtonEvent();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_allOneToTwoButton)) {
                ListElementChooserComposite.this.handleAllOneToTwoButtonEvent();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_allTwoToOneButton)) {
                ListElementChooserComposite.this.handleAllTwoToOneButtonEvent();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_listOne)) {
                ListElementChooserComposite.this.checkButtons();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_listTwo)) {
                ListElementChooserComposite.this.checkButtons();
                return;
            }
            Assert.notReached((String)Messages.EventActivatedByUnknownWidget);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ListElementChooserComposite.this.m_listOne)) {
                ListElementChooserComposite.this.handleSelectionOneToTwoButtonEvent();
                return;
            }
            if (o.equals(ListElementChooserComposite.this.m_listTwo)) {
                ListElementChooserComposite.this.handleSelectionTwoToOneButtonEvent();
                return;
            }
            Assert.notReached((String)Messages.EventActivatedByUnknownWidget);
        }
    }
}

