/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.lsp4e.debug.debugmodel.DSPVariable;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.StackFrame;

public class DSPStackFrame
extends DSPDebugElement
implements IStackFrame {
    private DSPThread thread;
    private StackFrame stackFrame;
    private int depth;

    public DSPStackFrame(DSPThread thread, StackFrame stackFrame, int depth) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.stackFrame = stackFrame;
        this.depth = depth;
    }

    public DSPStackFrame replace(StackFrame newStackFrame, int newDepth) {
        if (newDepth == this.depth && Objects.equals(newStackFrame.getSource(), this.stackFrame.getSource())) {
            this.stackFrame = newStackFrame;
            return this;
        }
        return new DSPStackFrame(this.thread, newStackFrame, newDepth);
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public void suspend() throws DebugException {
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public void stepReturn() throws DebugException {
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepInto() throws DebugException {
    }

    public boolean isStepping() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        ScopesArguments arguments = new ScopesArguments();
        arguments.setFrameId(this.stackFrame.getId());
        Scope[] scopes = ((ScopesResponse)DSPStackFrame.complete(this.getDebugTarget().getDebugProtocolServer().scopes(arguments))).getScopes();
        ArrayList<DSPVariable> vars = new ArrayList<DSPVariable>();
        Scope[] scopeArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            Scope scope = scopeArray[n2];
            DSPVariable variable = new DSPVariable(this, scope.getVariablesReference(), scope.getName(), "");
            vars.add(variable);
            ++n2;
        }
        return vars.toArray(new IVariable[vars.size()]);
    }

    public IThread getThread() {
        return this.thread;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public String getName() throws DebugException {
        return this.stackFrame.getName();
    }

    public int getLineNumber() throws DebugException {
        return (int)this.stackFrame.getLine().longValue();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getSourceName() {
        return this.stackFrame.getSource().getPath();
    }

    public Long getFrameId() {
        return this.stackFrame.getId();
    }

    public String toString() {
        return "StackFrame [depth=" + this.depth + ", line=" + this.stackFrame.getLine() + ", thread=" + (Object)((Object)this.thread) + ", stackFrame=" + this.stackFrame + "]";
    }
}

