/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WarningsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String[][] ERROR_SEVERITIES = new String[][]{{Messages.MavenWarningsPreferencePage_Ignore, ProblemSeverity.ignore.toString()}, {Messages.MavenWarningsPreferencePage_Warning, ProblemSeverity.warning.toString()}, {Messages.MavenWarningsPreferencePage_Error, ProblemSeverity.error.toString()}};
    private Composite parent;
    private static final List<String> SENSIBLE_PREFERENCES = Arrays.asList("eclipse.m2.problem.duplicateParentGroupId", "eclipse.m2.problem.duplicateParentVersion", "eclipse.m2.problem.notCoveredMojoExecution", "eclipse.m2.problem.outofdateProjectConfig", "eclipse.m2.problem.overridingManagedVersion");
    private Map<String, String> originalValues = new HashMap<String, String>();

    public WarningsPreferencePage() {
        super(1);
        this.setPreferenceStore(M2EUIPluginActivator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.addField(this.getDefaultCombo("eclipse.m2.problem.duplicateParentGroupId", Messages.MavenWarningsPreferencePage_groupidDupParent, this.parent));
        this.addField(this.getDefaultCombo("eclipse.m2.problem.duplicateParentVersion", Messages.MavenWarningsPreferencePage_versionDupParent, this.parent));
        this.addField(this.getDefaultCombo("eclipse.m2.problem.outofdateProjectConfig", Messages.MavenWarningsPreferencePage_OutOfDate_Project_Config, this.parent));
        this.addField(this.getDefaultCombo("eclipse.m2.problem.notCoveredMojoExecution", Messages.MavenWarningsPreferencePage_notCoveredMojoExecution, this.parent));
        this.addField(this.getDefaultCombo("eclipse.m2.problem.overridingManagedVersion", Messages.MavenWarningsPreferencePage_overridingManagedPreferences, this.parent));
        this.initOriginalValues();
    }

    private void initOriginalValues() {
        this.originalValues.clear();
        for (String pref : SENSIBLE_PREFERENCES) {
            this.originalValues.put(pref, this.getPreferenceStore().getString(pref));
        }
    }

    private FieldEditor getDefaultCombo(String key, String label, Composite parent) {
        return new ComboFieldEditor(key, label, ERROR_SEVERITIES, parent);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.updateProjects();
        }
        return result;
    }

    private void updateProjects() {
        boolean proceed;
        IMavenProjectFacade[] facades;
        if (this.isDirty() && (facades = MavenPlugin.getMavenProjectRegistry().getProjects()) != null && facades.length > 0 && (proceed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.MavenPreferencePage_updateProjectRequired_title, (String)Messages.MavenWarningsPreferencePage_changingProblemSeveritiesRequiresProjectUpdate))) {
            ArrayList<IProject> allProjects = new ArrayList<IProject>(facades.length);
            IMavenProjectFacade[] iMavenProjectFacadeArray = facades;
            int n = facades.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                allProjects.add(facade.getProject());
                ++n2;
            }
            new UpdateMavenProjectJob(allProjects.toArray(new IProject[allProjects.size()]), MavenPlugin.getMavenConfiguration().isOffline(), true, false, true, true).schedule();
            this.initOriginalValues();
        }
    }

    private boolean isDirty() {
        for (Map.Entry<String, String> original : this.originalValues.entrySet()) {
            if (StringUtils.equals((String)original.getValue(), (String)this.getPreferenceStore().getString(original.getKey()))) continue;
            return true;
        }
        return false;
    }
}

