/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.ui.wizard.project;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.util.Policy;
import org.eclipse.m2m.internal.qvt.oml.jdt.debug.ui.launch.DebugPDEMessages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.JdtProjectIntegration;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtProjectIntegrationImpl
implements JdtProjectIntegration {
    private static final IPath REQUIRED_PLUGINS_CONTAINER_PATH = new Path("org.eclipse.pde.core.requiredPlugins");
    private static Map<String, Integer> fSeverityTable = new HashMap<String, Integer>(3);
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;

    static {
        fSeverityTable.put("ignore", new Integer(1));
        fSeverityTable.put("warning", new Integer(2));
        fSeverityTable.put("error", new Integer(3));
    }

    public void setupJava(IProject project, boolean isPDE, String sourceFolder, String outFolder, String executionEnv, IProgressMonitor monitor) throws CoreException {
        org.eclipse.pde.internal.core.util.CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
        IContainer srcContainer = JdtProjectIntegrationImpl.createFolder(project, sourceFolder, monitor);
        IContainer binContainer = JdtProjectIntegrationImpl.createFolder(project, outFolder, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binContainer.getFullPath(), monitor);
        monitor.subTask(DebugPDEMessages.Setup_SettingClasspath);
        IClasspathEntry[] entries = new IClasspathEntry[isPDE ? 3 : 1];
        if (isPDE) {
            String executionEnvironment = executionEnv;
            JdtProjectIntegrationImpl.setComplianceOptions(javaProject, executionEnvironment, true);
            entries[0] = JdtProjectIntegrationImpl.createJREEntry(executionEnvironment);
            entries[1] = JdtProjectIntegrationImpl.createContainerEntry();
        }
        entries[entries.length - 1] = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
        javaProject.setRawClasspath(entries, monitor);
    }

    public String getRequiredExecutionEnv(String executionEnv) {
        if (JdtProjectIntegrationImpl.getEEnv(executionEnv) == null) {
            return null;
        }
        return "Bundle-RequiredExecutionEnvironment: " + executionEnv;
    }

    private static IClasspathEntry createJREEntry(String ee) {
        return JavaCore.newContainerEntry((IPath)JdtProjectIntegrationImpl.getEEPath(ee));
    }

    private static IPath getEEPath(String ee) {
        IExecutionEnvironment env;
        IPath path = null;
        if (ee != null && (env = JdtProjectIntegrationImpl.getEEnv(ee)) != null) {
            path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
        }
        if (path == null) {
            path = JavaRuntime.newDefaultJREContainerPath();
        }
        return path;
    }

    private static IExecutionEnvironment getEEnv(String ee) {
        if (ee != null) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            return manager.getEnvironment(ee);
        }
        return null;
    }

    private static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)REQUIRED_PLUGINS_CONTAINER_PATH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setComplianceOptions(IJavaProject project, String eeId, boolean overrideExisting) {
        Map projectMap = project.getOptions(false);
        IExecutionEnvironment ee = null;
        Map options = null;
        if (eeId != null && (ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId)) != null) {
            options = ee.getComplianceOptions();
        }
        if (options == null) {
            if (!overrideExisting || projectMap.size() <= 0) return;
            projectMap.remove("org.eclipse.jdt.core.compiler.compliance");
            projectMap.remove("org.eclipse.jdt.core.compiler.source");
            projectMap.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
        } else {
            String compliance = (String)options.get("org.eclipse.jdt.core.compiler.compliance");
            for (Map.Entry entry : options.entrySet()) {
                String option = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("1.3".equals(compliance) || "1.4".equals(compliance)) {
                    if ("org.eclipse.jdt.core.compiler.problem.assertIdentifier".equals(option) || "org.eclipse.jdt.core.compiler.problem.enumIdentifier".equals(option)) {
                        JdtProjectIntegrationImpl.setMinimumCompliance(projectMap, option, value, overrideExisting);
                        continue;
                    }
                    JdtProjectIntegrationImpl.setCompliance(projectMap, option, value, overrideExisting);
                    continue;
                }
                JdtProjectIntegrationImpl.setCompliance(projectMap, option, value, overrideExisting);
            }
        }
        project.setOptions(projectMap);
    }

    private static void setMinimumCompliance(Map<String, String> map, String key, String minimumValue, boolean override) {
        if (minimumValue != null && (override || !map.containsKey(key))) {
            int minimum;
            String currentValue = map.get(key);
            int current = currentValue != null && fSeverityTable.containsKey(currentValue) ? fSeverityTable.get(currentValue) : 0;
            int n = minimum = minimumValue != null && fSeverityTable.containsKey(minimumValue) ? fSeverityTable.get(minimumValue) : 0;
            if (current < minimum) {
                map.put(key, minimumValue);
            }
        }
    }

    private static void setCompliance(Map<String, String> map, String key, String value, boolean override) {
        if (value != null && (override || !map.containsKey(key))) {
            map.put(key, value);
        }
    }

    private static IContainer createFolder(IProject project, String folderName, IProgressMonitor monitor) throws CoreException {
        if (folderName == null || folderName.trim().length() == 0) {
            return project;
        }
        IFolder folder = project.getFolder(folderName);
        CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
        return folder;
    }

    public String getClassField(String id, String suffix) {
        IStatus status;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JdtProjectIntegrationImpl.validatePackageName(buffer.toString());
                if (status.getSeverity() == 4) {
                    buffer.append(suffix.toLowerCase());
                }
                buffer.append(ch);
            }
            ++i;
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            status = JdtProjectIntegrationImpl.validatePackageName(buffer.toString());
            if (status.getSeverity() == 4) {
                buffer.append(suffix.toLowerCase());
            }
            buffer.append("." + Character.toUpperCase(token.charAt(0)) + token.substring(1) + suffix);
        }
        return buffer.toString();
    }

    public IStatus validateJavaTypeName(String name) {
        return JavaConventions.validateJavaTypeName((String)name.trim(), (String)"1.3", (String)"1.3");
    }

    public void fillExecutionEnvironments(Combo combo) {
        IExecutionEnvironment[] fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        Arrays.sort(fInstalledEEs, new Comparator<IExecutionEnvironment>(){

            @Override
            public int compare(IExecutionEnvironment arg0, IExecutionEnvironment arg1) {
                return Policy.getComparator().compare(arg0.getId(), arg1.getId());
            }
        });
        String[] eeLabels = new String[fInstalledEEs.length];
        int i = 0;
        while (i < fInstalledEEs.length) {
            eeLabels[i] = fInstalledEEs[i].getId();
            ++i;
        }
        combo.setItems(eeLabels);
        combo.setText(JdtProjectIntegrationImpl.getDefaultEEName());
    }

    private static IStatus validatePackageName(String name) {
        return JavaConventions.validatePackageName((String)name, (String)"1.3", (String)"1.3");
    }

    private static String getDefaultEEName() {
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (defaultVM != null) {
            int i = 0;
            while (i < environments.length) {
                IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                    return environments[i].getId();
                }
                ++i;
            }
        }
        String defaultCC = "1.5";
        try {
            if (JavaModelUtil.class.getDeclaredField("VERSION_LATEST") != null) {
                defaultCC = JavaModelUtil.VERSION_LATEST;
            }
        }
        catch (Exception eeDefaultVM) {
            // empty catch block
        }
        if (defaultVM instanceof IVMInstall2) {
            defaultCC = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)defaultVM), (String)defaultCC);
        }
        int i = 0;
        while (i < environments.length) {
            String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environments[i]);
            if (defaultCC.endsWith(eeCompliance)) {
                return environments[i].getId();
            }
            ++i;
        }
        return "J2SE-1.5";
    }
}

