/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.ErrorHelper;

public class ExecuteQueryAction
extends Action {
    private MultiPaneEditor editor;
    private QueryDescriptor descriptor;
    private String commandLine;

    public ExecuteQueryAction(MultiPaneEditor editor, QueryDescriptor descriptor) {
        this.editor = editor;
        this.descriptor = descriptor;
        this.setText(descriptor.getName());
        this.setToolTipText(descriptor.getShortDescription());
        this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(descriptor));
    }

    public ExecuteQueryAction(MultiPaneEditor editor, String commandLine) {
        this.editor = editor;
        this.commandLine = commandLine;
        int p = commandLine.indexOf(32);
        String name = p < 0 ? commandLine : commandLine.substring(0, p);
        this.descriptor = QueryRegistry.instance().getQuery(name);
        this.setText(commandLine);
        if (this.descriptor != null) {
            this.setToolTipText(this.descriptor.getShortDescription());
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(this.descriptor));
        }
    }

    public void run() {
        try {
            if (this.commandLine != null) {
                QueryExecution.executeCommandLine(this.editor, null, this.commandLine);
            } else {
                QueryExecution.executeQuery(this.editor, this.descriptor);
            }
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }
}

