/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;

public abstract class AbstractElementOperation<T extends IBuildElement>
extends AbstractOperation {
    private List<BuildJob> jobs;

    public AbstractElementOperation(IOperationService service) {
        super(service);
    }

    protected abstract BuildJob doCreateJob(T var1);

    protected List<T> doInitInput() {
        final AtomicReference input = new AtomicReference();
        this.getService().getRealm().syncExec(new Runnable(){

            @Override
            public void run() {
                List elements = AbstractElementOperation.this.doSyncInitInput();
                AbstractElementOperation.this.register(elements);
                input.set(elements);
            }
        });
        return (List)input.get();
    }

    protected abstract List<T> doSyncInitInput();

    public void execute() {
        this.jobs = this.init();
        final MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, "Operation result", null);
        final CountDownLatch latch = new CountDownLatch(this.jobs.size());
        for (final BuildJob job : this.jobs) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    boolean fireDone;
                    BuildJob job2;
                    IStatus status;
                    if (event.getJob() instanceof BuildJob && (status = (job2 = (BuildJob)event.getJob()).getStatus()) != null && !status.isOK() && status.getSeverity() != 8) {
                        result.add(status);
                    }
                    CountDownLatch countDownLatch = latch;
                    synchronized (countDownLatch) {
                        latch.countDown();
                        fireDone = latch.getCount() == 0L;
                    }
                    job.removeJobChangeListener((IJobChangeListener)this);
                    if (fireDone) {
                        AbstractElementOperation.this.fireDone(result);
                    }
                }
            });
        }
        this.schedule(this.jobs);
    }

    protected void schedule(List<BuildJob> jobs) {
        this.getService().getScheduler().schedule(jobs);
    }

    public List<BuildJob> init() {
        List<T> input = this.doInitInput();
        ArrayList<BuildJob> jobs = new ArrayList<BuildJob>(input.size());
        for (IBuildElement element : input) {
            BuildJob job = this.doCreateJob(element);
            this.connect(job, element);
            jobs.add(job);
        }
        return jobs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus doExecute(IOperationMonitor progress) {
        List<BuildJob> jobs = this.init();
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, "Operation failed", null);
        progress.beginTask("", jobs.size());
        try {
            for (BuildJob job : jobs) {
                IStatus status = job.run((IProgressMonitor)progress.newChild(1));
                this.handleResult(job);
                final IBuildElement element = (IBuildElement)job.getAdapter(IBuildElement.class);
                if (element != null) {
                    this.getService().getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractElementOperation.this.unregister(element);
                        }
                    });
                }
                if (status.getSeverity() == 8) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    this.getService().getRealm().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractElementOperation.this.unregisterAll();
                        }
                    });
                    return iStatus;
                }
                if (status.isOK()) continue;
                result.add(status);
            }
        }
        catch (Throwable throwable) {
            this.getService().getRealm().asyncExec(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        this.getService().getRealm().asyncExec(new /* invalid duplicate definition of identical inner class */);
        return result;
    }

    public void cancel() {
        if (this.jobs != null) {
            for (BuildJob job : this.jobs) {
                job.cancel();
            }
        }
    }
}

