/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceElementPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CyclicPartitionAnalysis
extends AbstractCompositePartitionAnalysis<CyclicPartition> {
    protected final @NonNull Set<@NonNull PartitionAnalysis> externalPredecessors;

    public static @NonNull CyclicPartitionAnalysis createCyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull String name, @NonNull Set<@NonNull PartitionAnalysis> partitionAnalyses, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors) {
        HashMap<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> nestedPartitionAnalysis2predecessors = new HashMap<PartitionAnalysis, Set<PartitionAnalysis>>();
        HashSet<@NonNull PartitionAnalysis> externalPredecessors = new HashSet<PartitionAnalysis>();
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            HashSet<@NonNull E> internalPredecessors = new HashSet(partitionAnalysis2predecessors.get(partitionAnalysis));
            externalPredecessors.addAll(internalPredecessors);
            internalPredecessors.remove(partitionAnalysis);
            internalPredecessors.retainAll(partitionAnalyses);
            nestedPartitionAnalysis2predecessors.put(partitionAnalysis, internalPredecessors);
        }
        externalPredecessors.removeAll(partitionAnalyses);
        assert (!partitionAnalyses.isEmpty());
        ScheduleManager scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        CyclicPartition cyclicPartition = RegionHelper.createCyclicPartition(name, scheduleManager);
        return new CyclicPartitionAnalysis(partitionedTransformationAnalysis, cyclicPartition, nestedPartitionAnalysis2predecessors, externalPredecessors);
    }

    private CyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull CyclicPartition cyclicPartition, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors, @NonNull Set<@NonNull PartitionAnalysis> externalPredecessors) {
        super(partitionedTransformationAnalysis, cyclicPartition, partitionAnalysis2predecessors);
        this.externalPredecessors = externalPredecessors;
        partitionedTransformationAnalysis.addPartitionAnalysis(this);
        Set<@NonNull PartitionAnalysis> cyclicPartitionAnalyses = partitionAnalysis2predecessors.keySet();
        HashSet<@NonNull TracePropertyPartitionAnalysis> containmentTracePropertyPartitionAnalyses = new HashSet<TracePropertyPartitionAnalysis>();
        HashSet<@NonNull TracePropertyPartitionAnalysis> containerTracePropertyPartitionAnalyses = new HashSet<TracePropertyPartitionAnalysis>();
        for (PartitionAnalysis consumer : cyclicPartitionAnalyses) {
            Iterable<@NonNull TP> consumedTracePropertyAnalyses = consumer.getConsumedTracePropertyAnalyses();
            if (consumedTracePropertyAnalyses == null) continue;
            for (TracePropertyPartitionAnalysis consumedTracePropertyAnalysis : consumedTracePropertyAnalyses) {
                boolean isContainer;
                PropertyDatum propertyDatum = consumedTracePropertyAnalysis.getPropertyDatum();
                Property consumedProperty = propertyDatum.getReferredProperty();
                boolean isContainment = consumedProperty.isIsComposite();
                Property consumedOppositeProperty = consumedProperty.getOpposite();
                boolean bl = isContainer = consumedOppositeProperty != null && consumedOppositeProperty.isIsComposite();
                if (!isContainment && !isContainer) continue;
                for (PartitionAnalysis producer : consumedTracePropertyAnalysis.getProducers()) {
                    if (!cyclicPartitionAnalyses.contains(producer)) continue;
                    Partition producingPartition = producer.getPartition();
                    for (Edge edge : producingPartition.getPartialEdges()) {
                        NavigableEdge navigableEdge;
                        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                        if (!targetNode.isRealized() || !edge.isRealized() || !edge.isNavigation() || (navigableEdge = (NavigableEdge)edge).getProperty() != consumedProperty) continue;
                        if (isContainment) {
                            containmentTracePropertyPartitionAnalyses.add(consumedTracePropertyAnalysis);
                        }
                        if (!isContainer) continue;
                        containerTracePropertyPartitionAnalyses.add(consumedTracePropertyAnalysis);
                    }
                }
            }
        }
        System.out.println("Containment: " + containmentTracePropertyPartitionAnalyses);
        System.out.println("Container: " + containerTracePropertyPartitionAnalyses);
    }

    protected @NonNull Set<@NonNull PartitionAnalysis> computeBaseRecursingSteps(@NonNull Set<@NonNull PartitionAnalysis> recursingSteps, @NonNull Set<@NonNull PartitionAnalysis> badPredecessors) {
        HashSet<@NonNull PartitionAnalysis> baseRecursingSteps = new HashSet<PartitionAnalysis>();
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> immediatePredecessors = CompilerUtil.computeImmediatePredecessors(recursingSteps);
        for (PartitionAnalysis partitionAnalysis : recursingSteps) {
            Set<@NonNull PartitionAnalysis> predecessors = immediatePredecessors.get(partitionAnalysis);
            assert (predecessors != null);
            if (predecessors.removeAll(badPredecessors)) continue;
            baseRecursingSteps.add(partitionAnalysis);
        }
        return baseRecursingSteps;
    }

    protected @NonNull List<@NonNull Concurrency> computeRecursiveSchedule(@NonNull Set<@NonNull PartitionAnalysis> recursingSteps) {
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> immediatePredecessors = CompilerUtil.computeImmediatePredecessors(recursingSteps);
        for (PartitionAnalysis partitionAnalysis : recursingSteps) {
            Set<@NonNull PartitionAnalysis> predecessors = immediatePredecessors.get(partitionAnalysis);
            assert (predecessors != null);
            predecessors.retainAll(recursingSteps);
        }
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors = CompilerUtil.computeClosure(immediatePredecessors);
        return CompilerUtil.computeParallelSchedule(partitionAnalysis2predecessors);
    }

    /*
     * Could not resolve type clashes
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull Concurrency> createPartitionSchedule() {
        assert (this.partitionAnalyses.equals(this.originalPartitionAnalysis2predecessors.keySet()));
        HashMap<@NonNull PartitionAnalysis, @NonNull HashSet<@NonNull Object>> partitionAnalysis2acyclicTraceElementPartitionAnalyses = new HashMap<PartitionAnalysis, HashSet<Object>>();
        HashMap<@NonNull K, @NonNull @NonNull V> partitionAnalysis2cyclicTraceElementPartitionAnalyses = new HashMap();
        HashMap<@NonNull K, @NonNull @NonNull V> partitionAnalysis2mixedTraceElementPartitionAnalyses = new HashMap();
        for (PartitionAnalysis consumingPartitionAnalysis : this.partitionAnalyses) {
            Iterable consumedTracePropertyAnalyses;
            assert (!this.externalPredecessors.contains(consumingPartitionAnalysis));
            Iterable<@NonNull TC> consumedTraceClassAnalyses = consumingPartitionAnalysis.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses != null) {
                for (TraceClassPartitionAnalysis consumedTraceClassAnalysis : consumedTraceClassAnalyses) {
                    Iterable<PartitionAnalysis> producingPartitionAnalyses = consumedTraceClassAnalysis.getProducers();
                    boolean isExternal = false;
                    boolean isInternal = false;
                    Iterator iterator = producingPartitionAnalyses.iterator();
                    while (iterator.hasNext()) {
                        @NonNull PartitionAnalysis producingPartitionAnalysis = (PartitionAnalysis)iterator.next();
                        if (this.partitionAnalyses.contains(producingPartitionAnalysis)) {
                            isInternal = true;
                            continue;
                        }
                        isExternal = true;
                    }
                    HashMap<PartitionAnalysis, HashSet<Object>> partitionAnalysis2traceElementPartitionAnalyses = !isInternal ? partitionAnalysis2acyclicTraceElementPartitionAnalyses : (!isExternal ? partitionAnalysis2cyclicTraceElementPartitionAnalyses : partitionAnalysis2mixedTraceElementPartitionAnalyses);
                    HashSet<@NonNull TraceClassPartitionAnalysis> traceElementPartitionAnalyses = (HashSet<TraceClassPartitionAnalysis>)partitionAnalysis2traceElementPartitionAnalyses.get(consumingPartitionAnalysis);
                    if (traceElementPartitionAnalyses == null) {
                        traceElementPartitionAnalyses = new HashSet<TraceClassPartitionAnalysis>();
                        partitionAnalysis2traceElementPartitionAnalyses.put(consumingPartitionAnalysis, traceElementPartitionAnalyses);
                    }
                    traceElementPartitionAnalyses.add(consumedTraceClassAnalysis);
                }
            }
            if ((consumedTracePropertyAnalyses = consumingPartitionAnalysis.getConsumedTracePropertyAnalyses()) == null) continue;
            for (Object consumedTracePropertyAnalysis : consumedTracePropertyAnalyses) {
                Iterable<@NonNull PartitionAnalysis> producingPartitionAnalyses = ((TraceElementPartitionAnalysis)consumedTracePropertyAnalysis).getProducers();
                boolean isExternal = false;
                boolean isInternal = false;
                for (PartitionAnalysis producingPartitionAnalysis : producingPartitionAnalyses) {
                    boolean isInternallyContained = this.partitionAnalyses.contains(producingPartitionAnalysis);
                    boolean isExternallyContained = this.externalPredecessors.contains(producingPartitionAnalysis);
                    assert (!isInternallyContained || !isExternallyContained);
                    if (isInternallyContained) {
                        isInternal = true;
                        continue;
                    }
                    isExternal = true;
                }
                HashMap<PartitionAnalysis, HashSet<Object>> partitionAnalysis2traceElementPartitionAnalyses = !isInternal ? partitionAnalysis2acyclicTraceElementPartitionAnalyses : (!isExternal ? partitionAnalysis2cyclicTraceElementPartitionAnalyses : partitionAnalysis2mixedTraceElementPartitionAnalyses);
                HashSet<@NonNull Object> traceElementPartitionAnalyses = (HashSet<Object>)partitionAnalysis2traceElementPartitionAnalyses.get(consumingPartitionAnalysis);
                if (traceElementPartitionAnalyses == null) {
                    traceElementPartitionAnalyses = new HashSet<Object>();
                    partitionAnalysis2traceElementPartitionAnalyses.put(consumingPartitionAnalysis, traceElementPartitionAnalyses);
                }
                traceElementPartitionAnalyses.add(consumedTracePropertyAnalysis);
            }
        }
        HashSet<@NonNull PartitionAnalysis> baseCases = new HashSet<PartitionAnalysis>();
        HashSet<@NonNull PartitionAnalysis> recursiveCases = new HashSet<PartitionAnalysis>();
        HashSet<@NonNull PartitionAnalysis> recursingSteps = new HashSet<PartitionAnalysis>();
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            @NonNull Set acyclicTraceElementPartitionAnalyses = (Set)partitionAnalysis2acyclicTraceElementPartitionAnalyses.get(partitionAnalysis);
            @NonNull Set cyclicTraceElementPartitionAnalyses = (Set)partitionAnalysis2cyclicTraceElementPartitionAnalyses.get(partitionAnalysis);
            @NonNull Set mixedTraceElementPartitionAnalyses = (Set)partitionAnalysis2mixedTraceElementPartitionAnalyses.get(partitionAnalysis);
            Iterable<@NonNull PR> rawExplicitPredecessors = partitionAnalysis.getExplicitPredecessors();
            HashSet explicitPredecessors = null;
            if (rawExplicitPredecessors != null) {
                explicitPredecessors = Sets.newHashSet(rawExplicitPredecessors);
                explicitPredecessors.retainAll(this.partitionAnalyses);
                if (explicitPredecessors.isEmpty()) {
                    explicitPredecessors = null;
                }
            }
            if (explicitPredecessors != null) {
                recursingSteps.add(partitionAnalysis);
                continue;
            }
            if (mixedTraceElementPartitionAnalyses == null) {
                if (cyclicTraceElementPartitionAnalyses == null) {
                    if (acyclicTraceElementPartitionAnalyses == null ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
                recursingSteps.add(partitionAnalysis);
                continue;
            }
            if (cyclicTraceElementPartitionAnalyses == null) {
                baseCases.add(partitionAnalysis);
                continue;
            }
            recursiveCases.add(partitionAnalysis);
        }
        ArrayList<@NonNull Concurrency> partitionSchedule = new ArrayList<Concurrency>();
        this.appendConcurrency(partitionSchedule, baseCases);
        HashSet<PartitionAnalysis> residualSteps = null;
        if (recursingSteps.size() > 0) {
            Set<@NonNull PartitionAnalysis> baseRecursingSteps = this.computeBaseRecursingSteps(recursingSteps, recursiveCases);
            residualSteps = new HashSet<PartitionAnalysis>(recursingSteps);
            if (baseRecursingSteps.size() > 0) {
                residualSteps.removeAll(baseRecursingSteps);
                if (baseRecursingSteps.size() <= 1) {
                    this.appendConcurrency(partitionSchedule, baseRecursingSteps);
                } else {
                    List<@NonNull Concurrency> baseRecursiveSchedule = this.computeRecursiveSchedule(baseRecursingSteps);
                    for (Iterable concurrency : baseRecursiveSchedule) {
                        this.appendConcurrency(partitionSchedule, concurrency);
                    }
                }
            }
        }
        this.appendConcurrency(partitionSchedule, recursiveCases);
        if (residualSteps != null && !residualSteps.isEmpty()) {
            List<@NonNull Concurrency> residualSchedule = this.computeRecursiveSchedule(residualSteps);
            for (Iterable concurrency : residualSchedule) {
                this.appendConcurrency(partitionSchedule, concurrency);
            }
        }
        ((Concurrency)partitionSchedule.get(0)).setCycleStart();
        ((Concurrency)partitionSchedule.get(partitionSchedule.size() - 1)).setCycleEnd();
        return partitionSchedule;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getConsumedTraceClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getConsumedTracePropertyAnalyses() {
        return null;
    }

    @Override
    public @NonNull Set<@NonNull PartitionAnalysis> getExplicitPredecessors() {
        return this.externalPredecessors;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getProducedTraceClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getProducedTracePropertyAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getSuperProducedTraceClassAnalyses() {
        return null;
    }
}

