/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;

public class ConsoleHasText
extends AbstractWaitCondition {
    private String text;
    private ConsoleView consoleView;
    private String resultText;

    public ConsoleHasText(ConsoleView view, String text) {
        this.text = text;
        this.consoleView = view;
        view.open();
    }

    public ConsoleHasText(String text) {
        this(new ConsoleView(), text);
    }

    public ConsoleHasText() {
        this("");
    }

    public boolean test() {
        String consoleText = this.consoleView.getConsoleText();
        if (consoleText == null) {
            return false;
        }
        if (consoleText.contains(this.text)) {
            this.resultText = consoleText;
            return true;
        }
        return false;
    }

    public String description() {
        return "console contains '" + this.text + "'\n" + this.consoleView.getConsoleText();
    }

    public String errorMessageWhile() {
        return "console contains '" + this.text + "'\n" + this.consoleView.getConsoleText();
    }

    public String errorMessageUntil() {
        return "console does not contain text: '" + this.text + "', Console output:\n" + this.consoleView.getConsoleText();
    }

    public String getResult() {
        return this.resultText;
    }
}

