/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tcf.te.ui.trees.AbstractContentContribution;

public class ContentDescriptor {
    private final String id;
    private final IConfigurationElement element;
    private AbstractContentContribution contentContribution;
    private int rank = 100;

    public ContentDescriptor(String id, IConfigurationElement element) {
        Assert.isNotNull((Object)id);
        this.id = id;
        Assert.isNotNull((Object)element);
        this.element = element;
        String value = element.getAttribute("rank");
        if (value != null) {
            try {
                this.rank = Integer.decode(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String getId() {
        return this.id;
    }

    public int getRank() {
        return this.rank;
    }

    public AbstractContentContribution getContentContribution() {
        if (this.contentContribution == null) {
            try {
                this.contentContribution = (AbstractContentContribution)((Object)this.element.createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
        }
        return this.contentContribution;
    }

    public void dispose() {
        if (this.contentContribution != null) {
            this.contentContribution.dispose();
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContentDescriptor) {
            return this.id.equals(((ContentDescriptor)obj).id) && this.element.equals((Object)((ContentDescriptor)obj).element);
        }
        return super.equals(obj);
    }
}

