/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutMultipleProjectsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ProjectMetaFileOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ICVSWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.ModuleSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.NewLocationWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.RepositorySelectionPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class CheckoutWizard
extends Wizard
implements ICVSWizard,
INewWizard {
    private RepositorySelectionPage locationPage;
    private ConfigurationWizardMainPage createLocationPage;
    private ModuleSelectionPage modulePage;
    private CheckoutAsWizard wizard;
    private ICVSRepositoryLocation location;
    private boolean isNewLocation;
    private CVSWizardPage dummyPage;

    public CheckoutWizard() {
        this.setWindowTitle(CVSUIMessages.CheckoutWizard_0);
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        ImageDescriptor substImage = this.getBannerImageDescriptor();
        ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
        if (locations.length > 0) {
            this.locationPage = new RepositorySelectionPage("locationSelection", CVSUIMessages.CheckoutWizard_7, substImage);
            this.locationPage.setDescription(CVSUIMessages.SharingWizard_importTitleDescription);
            this.locationPage.setExtendedDescription(CVSUIMessages.CheckoutWizard_8);
            this.addPage((IWizardPage)this.locationPage);
        }
        this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", CVSUIMessages.SharingWizard_enterInformation, substImage);
        this.createLocationPage.setDescription(CVSUIMessages.SharingWizard_enterInformationDescription);
        this.addPage((IWizardPage)this.createLocationPage);
        this.createLocationPage.setDialogSettings(NewLocationWizard.getLocationDialogSettings());
        this.modulePage = new ModuleSelectionPage("moduleSelection", CVSUIMessages.CheckoutWizard_10, substImage);
        this.modulePage.setDescription(CVSUIMessages.CheckoutWizard_11);
        this.modulePage.setHelpContxtId("org.eclipse.team.cvs.ui.checkout_module_selection_context");
        this.modulePage.setSupportsMultiSelection(true);
        this.addPage((IWizardPage)this.modulePage);
        this.dummyPage = new CVSWizardPage("dummyPage"){

            public void createControl(Composite parent) {
                Composite composite = this.createComposite(parent, 1, false);
                this.setControl((Control)composite);
            }
        };
        this.addPage((IWizardPage)this.dummyPage);
    }

    protected ImageDescriptor getBannerImageDescriptor() {
        return CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.png");
    }

    public boolean canFinish() {
        return this.wizard == null && this.getSelectedModules().length > 0 || this.wizard != null && this.wizard.canFinish();
    }

    public boolean performFinish() {
        if (this.wizard != null) {
            if (this.isNewLocation) {
                KnownRepositories.getInstance().addRepository(this.location, true);
            }
            return true;
        }
        try {
            new CheckoutMultipleProjectsOperation(this.getPart(), this.getSelectedModules(), null).run();
            if (this.isNewLocation) {
                KnownRepositories.getInstance().addRepository(this.location, true);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private IWorkbenchPart getPart() {
        return null;
    }

    public boolean performCancel() {
        if (this.location != null && this.isNewLocation) {
            KnownRepositories.getInstance().disposeRepository(this.location);
            this.location = null;
        }
        return this.wizard == null || this.wizard.performCancel();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPage(page, true);
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page, boolean aboutToShow) {
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                return this.createLocationPage;
            }
            if (aboutToShow) {
                try {
                    this.modulePage.setLocation(this.getLocation());
                }
                catch (TeamException e1) {
                    CVSUIPlugin.log((CoreException)((Object)e1));
                }
            }
            return this.modulePage;
        }
        if (page == this.createLocationPage) {
            if (aboutToShow) {
                try {
                    ICVSRepositoryLocation l = this.getLocation();
                    if (l != null) {
                        this.modulePage.setLocation(l);
                    }
                }
                catch (TeamException e1) {
                    CVSUIPlugin.log((CoreException)((Object)e1));
                }
            }
            return this.modulePage;
        }
        if (page == this.modulePage) {
            ICVSRemoteFolder[] selectedModules = this.getSelectedModules();
            if (selectedModules.length == 0) {
                return null;
            }
            int i = 0;
            while (i < selectedModules.length) {
                ICVSRemoteFolder folder = selectedModules[i];
                if (folder.isDefinedModule()) {
                    return null;
                }
                ++i;
            }
            if (aboutToShow) {
                try {
                    boolean hasMetafile = true;
                    if (selectedModules.length == 1) {
                        ICVSRemoteFolder[] folders = new ICVSRemoteFolder[]{selectedModules[0]};
                        boolean withName = CVSUIPlugin.getPlugin().isUseProjectNameOnCheckout();
                        ICVSRemoteFolder[] folderResult = new ICVSRemoteFolder[1];
                        boolean[] booleanResult = new boolean[]{true};
                        this.getContainer().run(true, true, monitor -> {
                            ProjectMetaFileOperation op = new ProjectMetaFileOperation(this.getPart(), new ICVSRemoteFolder[]{folders[0]}, withName);
                            op.run(monitor);
                            iCVSRemoteFolderArray2[0] = op.getUpdatedFolders()[0];
                            blArray[0] = op.metaFileExists();
                        });
                        hasMetafile = booleanResult[0];
                        if (withName && hasMetafile) {
                            selectedModules[0] = folderResult[0];
                        }
                    }
                    this.resetSubwizard();
                    this.wizard = new CheckoutAsWizard(this.getPart(), selectedModules, !hasMetafile);
                    this.wizard.addPages();
                    return this.wizard.getStartingPage();
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.openError(this.getShell(), null, null, e);
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
            if (this.wizard == null) {
                return this.dummyPage;
            }
            return this.wizard.getStartingPage();
        }
        if (this.wizard != null) {
            return this.wizard.getNextPage(page);
        }
        return null;
    }

    private ICVSRemoteFolder[] getSelectedModules() {
        if (this.modulePage == null) {
            return null;
        }
        return this.modulePage.getSelectedModules();
    }

    private ICVSRepositoryLocation getLocation() throws TeamException {
        ICVSRepositoryLocation newLocation;
        if (this.locationPage != null && (newLocation = this.locationPage.getLocation()) != null) {
            return this.recordLocation(newLocation);
        }
        ICVSRepositoryLocation[] locations = new ICVSRepositoryLocation[1];
        CVSException[] exception = new CVSException[1];
        this.getShell().getDisplay().syncExec(() -> {
            try {
                iCVSRepositoryLocationArray[0] = this.createLocationPage.getLocation();
            }
            catch (CVSException e) {
                cVSExceptionArray[0] = e;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return this.recordLocation(locations[0]);
    }

    private ICVSRepositoryLocation recordLocation(ICVSRepositoryLocation newLocation) {
        if (newLocation == null) {
            return this.location;
        }
        if (this.location == null || !newLocation.equals(this.location)) {
            if (this.location != null && this.isNewLocation) {
                KnownRepositories.getInstance().disposeRepository(this.location);
            }
            this.location = newLocation;
            boolean bl = this.isNewLocation = !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation(false));
            if (this.isNewLocation) {
                this.location = KnownRepositories.getInstance().addRepository(this.location, false);
            }
        }
        return this.location;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    void resetSubwizard() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }
}

