/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public interface SegmentComparators {
    public static final Comparator<Long> LONG_COMPARATOR = new Comparator<Long>(){

        @Override
        public int compare(@Nullable Long o1, @Nullable Long o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException();
            }
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<ISegment> INTERVAL_START_COMPARATOR = new Comparator<ISegment>(){

        @Override
        public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException();
            }
            return Long.compare(o1.getStart(), o2.getStart());
        }
    };
    public static final Comparator<ISegment> INTERVAL_END_COMPARATOR = new Comparator<ISegment>(){

        @Override
        public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException();
            }
            return Long.compare(o1.getEnd(), o2.getEnd());
        }
    };
    public static final Comparator<ISegment> INTERVAL_LENGTH_COMPARATOR = new Comparator<ISegment>(){

        @Override
        public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException();
            }
            return Long.compare(o1.getLength(), o2.getLength());
        }
    };
}

