/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class EngineError {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final String message;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final Throwable t;
  
  public EngineError(final String message, final Throwable t) {
    super();
    this.message = message;
    this.t = t;
  }
  
  @Pure
  public String getMessage() {
    return this.message;
  }
  
  @Pure
  public Throwable getT() {
    return this.t;
  }
}
