(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../parser/cssNodes", "vscode-languageserver-types", "./lintRules", "./lint"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var nodes = require("../parser/cssNodes");
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var lintRules_1 = require("./lintRules");
    var lint_1 = require("./lint");
    var CSSValidation = /** @class */ (function () {
        function CSSValidation() {
        }
        CSSValidation.prototype.configure = function (settings) {
            this.settings = settings;
        };
        CSSValidation.prototype.doValidation = function (document, stylesheet, settings) {
            if (settings === void 0) { settings = this.settings; }
            if (settings && settings.validate === false) {
                return [];
            }
            var entries = [];
            entries.push.apply(entries, nodes.ParseErrorCollector.entries(stylesheet));
            entries.push.apply(entries, lint_1.LintVisitor.entries(stylesheet, document, new lintRules_1.LintConfigurationSettings(settings && settings.lint)));
            var ruleIds = [];
            for (var r in lintRules_1.Rules) {
                ruleIds.push(lintRules_1.Rules[r].id);
            }
            function toDiagnostic(marker) {
                var range = vscode_languageserver_types_1.Range.create(document.positionAt(marker.getOffset()), document.positionAt(marker.getOffset() + marker.getLength()));
                var source = ruleIds.indexOf(marker.getRule().id) !== -1
                    ? document.languageId + ".lint." + marker.getRule().id
                    : document.languageId;
                return {
                    code: marker.getRule().id,
                    source: source,
                    message: marker.getMessage(),
                    severity: marker.getLevel() === nodes.Level.Warning ? vscode_languageserver_types_1.DiagnosticSeverity.Warning : vscode_languageserver_types_1.DiagnosticSeverity.Error,
                    range: range
                };
            }
            return entries.filter(function (entry) { return entry.getLevel() !== nodes.Level.Ignore; }).map(toDiagnostic);
        };
        return CSSValidation;
    }());
    exports.CSSValidation = CSSValidation;
});
//# sourceMappingURL=cssValidation.js.map