/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.StatementExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcExecutor
implements StatementExecutor {
    private final Statement stmt;

    public JdbcExecutor(JdbcSchema schema) throws OrmException {
        this(schema.getConnection());
    }

    public JdbcExecutor(Connection c) throws OrmException {
        try {
            this.stmt = c.createStatement();
        }
        catch (SQLException e) {
            throw new OrmException("Cannot create statement for executor", e);
        }
    }

    @Override
    public void execute(String sql) throws OrmException {
        try {
            this.stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new OrmException("Cannot apply SQL\n" + sql, e);
        }
    }

    public void close() {
        try {
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

