/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.sql.ResultSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class MethodCallNode
extends JavaValueNode {
    String methodName;
    String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    MethodCallNode(String string, ContextManager contextManager) {
        super(contextManager);
        this.methodName = string;
    }

    String getMethodName() {
        return this.methodName;
    }

    TableName getFullName() {
        return null;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public Member getResolvedMethod() {
        return this.method;
    }

    public RoutineAliasInfo getRoutineInfo() {
        return this.routineInfo;
    }

    void addParms(List<ValueNode> list) throws StandardException {
        this.methodParms = new JavaValueNode[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = list.get(i);
            SQLToJavaValueNode sQLToJavaValueNode = new SQLToJavaValueNode(valueNode, this.getContextManager());
            this.methodParms[i] = sQLToJavaValueNode;
        }
    }

    Class<?>[] getMethodParameterClasses() {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        Class[] classArray = new Class[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            String string = this.methodParameterTypes[i];
            try {
                classArray[i] = classInspector.getClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return classArray;
    }

    void getCorrelationTables(JBitSet jBitSet) throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.accept(collectNodesVisitor);
        for (ColumnReference columnReference : collectNodesVisitor.getList()) {
            if (!columnReference.getCorrelated()) continue;
            jBitSet.set(columnReference.getTableNumber());
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public String toString() {
        return "";
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this.methodParms != null) {
            int n = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[n];
            }
            for (int i = 0; i < n; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].bindExpression(fromList, subqueryList, list);
                if (this.routineInfo == null) {
                    this.signature[i] = this.methodParms[i].getJSQLType();
                }
                SelectNode.checkNoWindowFunctions(this.methodParms[i], "method argument");
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String string, String[] stringArray, String[] stringArray2) throws StandardException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.signature.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            boolean bl = this.isVararg(i);
            String string2 = stringArray[i];
            if (stringArray[i].length() == 0) {
                string2 = "UNTYPED";
            } else if (bl) {
                string2 = this.getVarargTypeName(string2);
            }
            stringBuilder.append(string2);
            if (stringArray2 == null || stringArray2[i].equals(stringArray[i])) continue;
            String string3 = stringArray2[i];
            if (bl) {
                string3 = this.getVarargTypeName(string3);
            }
            stringBuilder.append("(" + string3 + ")");
        }
        throw StandardException.newException("42X50", string, this.methodName, stringBuilder);
    }

    private String getVarargTypeName(String string) {
        return this.stripOneArrayLevel(string) + "...";
    }

    @Override
    void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i].preprocess(n, fromList, subqueryList, predicateList);
            }
        }
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                bl2 = this.methodParms[i].categorize(jBitSet, bl) && bl2;
            }
        }
        return bl2;
    }

    @Override
    JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].remapColumnReferencesToExpressions();
            }
        }
        return this;
    }

    public boolean hasVarargs() {
        return this.routineInfo == null ? false : this.routineInfo.hasVarargs();
    }

    public int getFirstVarargIdx() {
        return this.signature.length - 1;
    }

    public boolean isVararg(int n) {
        if (!this.hasVarargs()) {
            return false;
        }
        return n >= this.getFirstVarargIdx();
    }

    public int generateParameters(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.hasVarargs() ? this.routineInfo.getParameterCount() - 1 : this.methodParms.length;
        int n2 = this.hasVarargs() ? n + 1 : n;
        for (int i = 0; i < n; ++i) {
            this.generateAndCastOneParameter(expressionClassBuilder, methodBuilder, i, this.methodParameterTypes[i]);
        }
        if (this.hasVarargs()) {
            this.generateVarargs(expressionClassBuilder, methodBuilder);
        }
        return n2;
    }

    private void generateAndCastOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n, String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        this.generateOneParameter(expressionClassBuilder, methodBuilder, n);
        String string2 = MethodCallNode.getParameterTypeName(this.methodParms[n]);
        if (!string.equals(string2)) {
            if (ClassInspector.primitiveType(string2) && string.equals(JSQLType.getWrapperClassName(JSQLType.getPrimitiveID(string2)))) {
                if ("short".equals(string2)) {
                    methodBuilder.cast("int");
                }
                methodBuilder.callMethod((short)184, string, "valueOf", string, 1);
            } else if (ClassInspector.primitiveType(string)) {
                methodBuilder.cast(string);
            } else {
                if (this.routineInfo != null) {
                    return;
                }
                methodBuilder.upCast(string);
            }
        }
    }

    private void generateVarargs(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        String string;
        int n2 = this.getFirstVarargIdx();
        String string2 = this.methodParameterTypes[n2];
        String string3 = string = this.stripOneArrayLevel(string2);
        if (this.routineInfo != null && this.routineInfo.getParameterModes()[n2] != 1) {
            string3 = this.stripOneArrayLevel(string3);
        }
        if ((n = this.methodParms.length - n2) < 0) {
            n = 0;
        }
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray(string, n);
        methodBuilder2.setField(localField);
        for (int i = 0; i < n; ++i) {
            methodBuilder.getField(localField);
            this.generateAndCastOneParameter(expressionClassBuilder, methodBuilder, i + n2, string);
            methodBuilder.setArrayElement(i);
        }
        methodBuilder.getField(localField);
    }

    protected int getRoutineArgIdx(int n) {
        if (this.routineInfo == null) {
            return n;
        }
        return this.getRoutineArgIdx(this.routineInfo, n);
    }

    protected int getRoutineArgIdx(RoutineAliasInfo routineAliasInfo, int n) {
        if (!routineAliasInfo.hasVarargs()) {
            return n;
        }
        int n2 = routineAliasInfo.getParameterCount() - 1;
        return n2 < n ? n2 : n;
    }

    public static String getParameterTypeName(JavaValueNode javaValueNode) throws StandardException {
        String string = javaValueNode.isPrimitiveType() ? javaValueNode.getPrimitiveTypeName() : javaValueNode.getJavaTypeName();
        return string;
    }

    void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.methodParms[n].generateExpression(expressionClassBuilder, methodBuilder);
    }

    void setNullParameterInfo(String[] stringArray) throws StandardException {
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!this.methodParms[i].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(stringArray[i]);
            ((SQLToJavaValueNode)this.methodParms[i]).value.setType(dataTypeDescriptor);
            this.methodParms[i].setJavaTypeName(stringArray[i]);
            this.signature[i] = this.methodParms[i].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String string, boolean bl) throws StandardException {
        int n;
        int n2;
        String string2;
        String string3;
        String[] stringArray;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", string + (bl ? "::" : ".") + this.methodName);
        }
        int n3 = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] stringArray2 = null;
        boolean[] blArray = this.getIsParam();
        boolean bl2 = this.hasVarargs() ? false : this.routineInfo != null && n3 != 0 && n3 != this.methodParms.length;
        int n4 = this.methodName.indexOf(40);
        if (n4 != -1) {
            stringArray = this.parseValidateSignature(this.methodName, n4, bl2);
            this.methodName = this.methodName.substring(0, n4);
            bl2 = false;
        } else {
            stringArray = this.getObjectSignature();
        }
        if (this.hasVarargs()) {
            stringArray[n3 - 1] = stringArray[n3 - 1] + "[]";
        }
        try {
            this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, null, blArray, bl, bl2, this.hasVarargs());
            if (n4 == -1 && this.routineInfo == null && this.method == null) {
                stringArray2 = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, stringArray2, blArray, bl, bl2, this.hasVarargs());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(string, stringArray, stringArray2);
        }
        this.actualMethodReturnType = string3 = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (string3.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09", new Object[0]);
            }
        } else {
            Object object;
            String string4;
            string2 = null;
            TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)this.routineInfo.getReturnType();
            if (typeDescriptorImpl == null) {
                string4 = "void";
            } else {
                TypeId typeId = TypeId.getBuiltInTypeId(typeDescriptorImpl.getJDBCTypeId());
                if (typeDescriptorImpl.isRowMultiSet() && this.routineInfo.getParameterStyle() == 1) {
                    string4 = ResultSet.class.getName();
                } else if (typeDescriptorImpl.getTypeId().userType()) {
                    string4 = ((UserDefinedTypeIdImpl)typeDescriptorImpl.getTypeId()).getClassName();
                } else {
                    string4 = typeId.getCorrespondingJavaTypeName();
                    if (!string4.equals(string3)) {
                        switch (typeDescriptorImpl.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                object = this.getTypeCompiler(typeId);
                                string4 = object.getCorrespondingPrimitiveTypeName();
                                if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                                string2 = typeId.getCorrespondingJavaTypeName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ResultSet.class.getName().equals(string4)) {
                try {
                    object = classInspector.getClass(string3);
                    n2 = ResultSet.class.isAssignableFrom((Class<?>)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n2 = 0;
                }
            } else {
                n2 = string4.equals(string3);
            }
            if (n2 == 0) {
                this.throwNoMethodFound(string4 + " " + string, stringArray, stringArray2);
            }
            if (string2 != null) {
                string3 = string2;
            }
            if (this.routineInfo.getReturnType() != null) {
                this.setCollationType(this.routineInfo.getReturnType().getCollationType());
            }
        }
        this.setJavaTypeName(string3);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        string2 = null;
        block12: for (n = 0; n < this.methodParameterTypes.length; ++n) {
            string2 = this.methodParameterTypes[n];
            if (this.routineInfo != null && n < this.routineInfo.getParameterCount()) {
                int n5 = this.routineInfo.getParameterModes()[this.getRoutineArgIdx(n)];
                switch (n5) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        string2 = this.stripOneArrayLevel(string2);
                        break;
                    }
                    case 4: {
                        continue block12;
                    }
                }
            }
            if (this.hasVarargs() && n >= this.getFirstVarargIdx()) {
                string2 = this.stripOneArrayLevel(string2);
            }
            if (!ClassInspector.primitiveType(string2) || n >= this.methodParms.length) continue;
            this.methodParms[n].castToPrimitive(true);
        }
        if (this.hasVarargs()) {
            n = this.getFirstVarargIdx();
            int n6 = this.methodParms.length - n;
            for (n2 = 1; n2 < n6; ++n2) {
                if (!ClassInspector.primitiveType(string2)) continue;
                this.methodParms[n2 + n].castToPrimitive(true);
            }
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string3);
        if (this.getCompilerContext().getReturnParameterFlag()) {
            this.getParameterTypes()[0] = dataTypeDescriptor;
        }
    }

    protected String stripOneArrayLevel(String string) {
        return string.substring(0, string.length() - 2);
    }

    private String[] parseValidateSignature(String string, int n, boolean bl) throws StandardException {
        String[] stringArray;
        int n2 = string.length();
        if (n + 1 == n2 || string.charAt(n2 - 1) != ')') {
            throw StandardException.newException("46J01", new Object[0]);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2 - 1), ",", true);
        String[] stringArray2 = new String[this.signature.length];
        boolean bl2 = false;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray3;
            Object object;
            stringArray = stringTokenizer.nextToken().trim();
            if (",".equals(stringArray)) {
                if (!bl2) {
                    throw StandardException.newException("46J01", new Object[0]);
                }
                bl2 = false;
                continue;
            }
            if (stringArray.length() == 0) {
                throw StandardException.newException("46J01", new Object[0]);
            }
            bl2 = true;
            if (++n3 > this.signature.length) {
                if (bl) {
                    object = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!stringArray.equals(object)) {
                        throw StandardException.newException("22005", stringArray, object);
                    }
                    if (stringArray2.length == this.signature.length) {
                        stringArray3 = new String[stringTokenizer.countTokens()];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        stringArray2 = stringArray3;
                    }
                    stringArray2[n3 - 1] = stringArray;
                    continue;
                }
                throw StandardException.newException("46J02", Integer.toString(n3), Integer.toString(this.signature.length));
            }
            object = this.signature[n3 - 1].getSQLType().getTypeId();
            if (stringArray.equals(((TypeId)object).getCorrespondingJavaTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            if ((((TypeId)object).isNumericTypeId() && !((TypeId)object).isDecimalTypeId() || ((TypeId)object).isBooleanTypeId()) && stringArray.equals((stringArray3 = this.getTypeCompiler((TypeId)object)).getCorrespondingPrimitiveTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            throw StandardException.newException("22005", stringArray, ((TypeId)object).getSQLTypeName());
        }
        if (n3 != 0 && !bl2) {
            throw StandardException.newException("46J01", new Object[0]);
        }
        if (n3 < stringArray2.length) {
            if (bl && n3 == this.signature.length - 1) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                return stringArray;
            }
            throw StandardException.newException("46J02", Integer.toString(n3), Integer.toString(this.signature.length));
        }
        return stringArray2;
    }

    protected boolean someParametersAreNull() {
        int n = this.signature.length;
        for (int i = 0; i < n; ++i) {
            if (this.signature[i] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        TypeCompilerFactory typeCompilerFactory = this.routineInfo == null ? null : this.getCompilerContext().getTypeCompilerFactory();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = MethodCallNode.getObjectTypeName(this.signature[i], typeCompilerFactory);
        }
        return stringArray;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!(this.methodParms[i] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[i];
            if (!sQLToJavaValueNode.value.requiresTypeFromContext()) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    static String getObjectTypeName(JSQLType jSQLType, TypeCompilerFactory typeCompilerFactory) throws StandardException {
        if (jSQLType != null) {
            switch (jSQLType.getCategory()) {
                case 0: {
                    TypeId typeId = MethodCallNode.mapToTypeID(jSQLType);
                    if (typeId == null) {
                        return null;
                    }
                    switch (typeId.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 16: {
                            if (typeCompilerFactory == null) break;
                            return typeCompilerFactory.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return typeId.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jSQLType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                }
            }
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean bl) throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        block5: for (int i = 0; i < n; ++i) {
            JSQLType jSQLType = this.signature[i];
            if (jSQLType == null) {
                stringArray[i] = "";
                continue;
            }
            switch (jSQLType.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && i < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[i] != null) {
                        stringArray[i] = this.procedurePrimitiveArrayType[i];
                        continue block5;
                    }
                    TypeId typeId = MethodCallNode.mapToTypeID(jSQLType);
                    if (typeId.isNumericTypeId() && !typeId.isDecimalTypeId() || typeId.isBooleanTypeId()) {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        stringArray[i] = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (!bl) continue block5;
                        this.methodParms[i].castToPrimitive(true);
                        continue block5;
                    }
                    stringArray[i] = typeId.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    stringArray[i] = jSQLType.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    stringArray[i] = JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                    if (!bl) continue block5;
                    this.methodParms[i].castToPrimitive(true);
                    continue block5;
                }
            }
        }
        return stringArray;
    }

    @Override
    int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int n = 2;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] != null) {
                    int n2 = this.methodParms[i].getOrderableVariantType();
                    if (n2 >= n) continue;
                    n = n2;
                    continue;
                }
                n = 0;
            }
        }
        return n;
    }

    @Override
    DataTypeDescriptor getDataType() throws StandardException {
        TypeDescriptor typeDescriptor;
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            return DataTypeDescriptor.getType(typeDescriptor);
        }
        return super.getDataType();
    }

    JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        for (int i = 0; !visitor.stopTraversal() && i < this.methodParms.length; ++i) {
            if (this.methodParms[i] == null) continue;
            this.methodParms[i] = (JavaValueNode)this.methodParms[i].accept(visitor);
        }
    }
}

