/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public abstract class AbstractCommandSupport
extends AbstractLoggingBean
implements Command,
Runnable,
ExecutorServiceCarrier,
SessionAware,
SessionHolder<Session>,
ServerSessionHolder {
    protected final String command;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected Environment environment;
    protected Future<?> cmdFuture;
    protected Thread cmdRunner;
    protected CloseableExecutorService executorService;
    protected boolean cbCalled;
    protected ServerSession serverSession;

    protected AbstractCommandSupport(String command, CloseableExecutorService executorService) {
        this.command = command;
        if (executorService == null) {
            String poolName = GenericUtils.isEmpty(command) ? this.getClass().getSimpleName() : command.replace(' ', '_').replace('/', ':');
            this.executorService = ThreadUtils.newSingleThreadExecutor(poolName);
        } else {
            this.executorService = executorService;
        }
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public Session getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void setSession(ServerSession session) {
        this.serverSession = session;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executorService;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public ExitCallback getExitCallback() {
        return this.callback;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected Future<?> getStartedCommandFuture() {
        return this.cmdFuture;
    }

    @Override
    public void start(Environment env) throws IOException {
        this.environment = env;
        try {
            CloseableExecutorService executors = this.getExecutorService();
            this.cmdFuture = executors.submit(() -> {
                this.cmdRunner = Thread.currentThread();
                this.run();
            });
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command=" + this.command + ": " + e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void destroy() {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.cmdFuture != null && !this.cmdFuture.isDone() && this.cmdRunner != Thread.currentThread()) {
            boolean result = this.cmdFuture.cancel(true);
            if (debugEnabled) {
                this.log.debug("destroy() - cancel pending future=" + result);
            }
        }
        this.cmdFuture = null;
        CloseableExecutorService executors = this.getExecutorService();
        if (executors != null && !executors.isShutdown()) {
            List<Runnable> runners = executors.shutdownNow();
            if (debugEnabled) {
                this.log.debug("destroy() - shutdown executor service - runners count=" + runners.size());
            }
        }
        this.executorService = null;
    }

    protected void onExit(int exitValue) {
        this.onExit(exitValue, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExit(int exitValue, String exitMessage) {
        if (this.cbCalled) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("onExit({}) ignore exitValue={}, message={} - already called", new Object[]{this, exitValue, exitMessage});
            }
            return;
        }
        ExitCallback cb = this.getExitCallback();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("onExit({}) exiting - value={}, message={}", new Object[]{this, exitValue, exitMessage});
            }
            cb.onExit(exitValue, exitMessage);
        }
        finally {
            this.cbCalled = true;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getCommand() + "]";
    }
}

