/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.oda.excel.impl.i18n.Messages;
import org.eclipse.birt.report.data.oda.excel.impl.util.querytextutil.ColumnsInfoUtil;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaDataHelper {
    String savedSelectedColumnsInfoString;
    String[] columnNames;
    String[] columnTypes;
    String[] originalColumnNames;
    String[] columnLabels;
    private Map<String, Integer> columnNameIndexMap = new HashMap<String, Integer>();

    public ResultSetMetaDataHelper(String[] colNames, String[] colTypes, String[] colLabels) throws OdaException {
        if (colNames == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.columnNames = colNames;
        this.columnTypes = colTypes;
        this.columnLabels = colLabels;
        this.originalColumnNames = colNames;
        this.trimMetaDataStrings();
        this.initMap();
    }

    public ResultSetMetaDataHelper(String savedSelectedColumnsInfoString) {
        this.savedSelectedColumnsInfoString = savedSelectedColumnsInfoString;
        ColumnsInfoUtil ciu = new ColumnsInfoUtil(savedSelectedColumnsInfoString);
        this.columnNames = ciu.getColumnNames();
        this.columnTypes = ciu.getColumnTypeNames();
        this.originalColumnNames = ciu.getOriginalColumnNames();
        this.columnLabels = this.columnNames;
        this.trimMetaDataStrings();
        this.initMap();
    }

    private void initMap() {
        int i = 0;
        while (i < this.columnNames.length) {
            this.columnNameIndexMap.put(this.columnNames[i], i);
            ++i;
        }
    }

    private void trimMetaDataStrings() {
        assert (this.columnNames.length == this.columnTypes.length && this.columnTypes.length == this.originalColumnNames.length && this.originalColumnNames.length == this.columnLabels.length);
        int i = 0;
        while (i < this.columnNames.length) {
            this.columnNames[i] = this.columnNames[i].trim();
            this.columnTypes[i] = this.columnTypes[i].trim();
            this.columnLabels[i] = this.columnLabels[i].trim();
            this.originalColumnNames[i] = this.originalColumnNames[i].trim();
            ++i;
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getColumnTypes() {
        return this.columnTypes;
    }

    public String[] getColumnLabels() {
        return this.columnLabels;
    }

    public String[] getOriginalColumnNames() {
        return this.originalColumnNames;
    }

    public String getOriginalColumnName(String columnName) {
        String originName = null;
        Integer index = this.columnNameIndexMap.get(columnName);
        if (index != null) {
            originName = this.originalColumnNames[index];
        }
        return originName;
    }
}

