/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SvgFile {
    private static Logger logger = Logger.getLogger(SvgFile.class.getName());
    static boolean isSvg = false;

    public static boolean isSvg(String uri) {
        isSvg = uri != null && uri.endsWith(".svg");
        return isSvg;
    }

    public static boolean isSvg(String mimeType, String uri, String extension) {
        isSvg = mimeType != null && mimeType.equalsIgnoreCase("image/svg+xml") || uri != null && uri.toLowerCase().endsWith(".svg") || extension != null && extension.toLowerCase().endsWith(".svg");
        return isSvg;
    }

    public static byte[] transSvgToArray(String uri) throws Exception {
        InputStream in = new URL(uri).openStream();
        try {
            byte[] byArray = SvgFile.transSvgToArray(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] transSvgToArray(InputStream inputStream) throws Exception {
        PNGTranscoder transcoder = new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(inputStream);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        transcoder.transcode(input, output);
        ostream.flush();
        return ostream.toByteArray();
    }
}

