/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.BaseCrosstabAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.util.ModelUtil;

public class AddLevelAttributeHandleCommand
extends AbstractCrosstabCommand {
    private BaseCrosstabAdapter handleAdpter;
    private int type = -1;
    private LevelAttributeHandle[] levelAttributeHandles;
    private DimensionHandle[] dimensionHandles;
    private DimensionHandle dimensionHandle;
    private Object after;
    private static final String NAME = Messages.getString("AddDimensionViewHandleCommand.TransName");

    public AddLevelAttributeHandleCommand(CrosstabCellAdapter handleAdpter, int type, DimensionHandle dimensionHandle, LevelAttributeHandle[] levelAttrHandles, Object after) {
        super((DesignElementHandle)dimensionHandle);
        this.dimensionHandle = dimensionHandle;
        this.levelAttributeHandles = levelAttrHandles;
        this.setHandleAdpter(handleAdpter);
        this.setType(type);
        this.setDimensionHandles(new DimensionHandle[]{dimensionHandle});
        this.after = after;
        this.setLabel(NAME);
    }

    public AddLevelAttributeHandleCommand(CrosstabHandleAdapter handleAdpter, int type, DimensionHandle dimensionHandle, LevelAttributeHandle[] levelAttrHandles) {
        super((DesignElementHandle)dimensionHandle);
        this.dimensionHandle = dimensionHandle;
        this.levelAttributeHandles = levelAttrHandles;
        this.setHandleAdpter(handleAdpter);
        this.setType(type);
        this.setDimensionHandles(new DimensionHandle[]{dimensionHandle});
        this.setLabel(NAME);
    }

    public void setHandleAdpter(BaseCrosstabAdapter handleAdpter) {
        this.handleAdpter = handleAdpter;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean canExecute() {
        return this.getType() != -1;
    }

    public CrosstabReportItemHandle getCrosstabHandle() {
        if (this.handleAdpter instanceof CrosstabHandleAdapter) {
            return (CrosstabReportItemHandle)((CrosstabHandleAdapter)this.handleAdpter).getCrosstabItemHandle();
        }
        if (this.handleAdpter instanceof CrosstabCellAdapter) {
            return ((CrosstabCellAdapter)this.handleAdpter).getCrosstabCellHandle().getCrosstab();
        }
        return null;
    }

    public void execute() {
        if (this.levelAttributeHandles != null && this.levelAttributeHandles.length > 0) {
            this.transStart(NAME);
            CrosstabReportItemHandle crosstabHandle = this.getCrosstabHandle();
            try {
                DimensionViewHandle viewHandle = null;
                int position = this.findCellPosition();
                if (CrosstabUtil.canContain((CrosstabReportItemHandle)crosstabHandle, (DimensionHandle)this.dimensionHandle)) {
                    if (crosstabHandle.getCube() == null) {
                        crosstabHandle.setCube(CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)this.dimensionHandle));
                    }
                    viewHandle = crosstabHandle.insertDimension(this.dimensionHandle, this.getType(), position);
                } else {
                    viewHandle = crosstabHandle.getDimension(this.getType(), position - 1);
                }
                LevelHandle levelHandle = (LevelHandle)this.levelAttributeHandles[0].getElementHandle();
                if (levelHandle == null) {
                    this.rollBack();
                    return;
                }
                LevelViewHandle levelViewHandle = null;
                if (viewHandle.getLevel(levelHandle.getQualifiedName()) == null) {
                    DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)crosstabHandle.getModelHandle()), levelHandle);
                    levelViewHandle = viewHandle.insertLevel(levelHandle, viewHandle.getLevelCount());
                    CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                    cellHandle.addContent((DesignElementHandle)dataHandle);
                    ActionHandle actionHandle = levelHandle.getActionHandle();
                    if (actionHandle != null) {
                        ArrayList<IStructure> source = new ArrayList<IStructure>();
                        source.add(actionHandle.getStructure());
                        ArrayList newAction = ModelUtil.cloneStructList(source);
                        dataHandle.setAction((Action)newAction.get(0));
                    }
                    CrosstabUtil.addLabelToHeader((LevelViewHandle)levelViewHandle);
                } else {
                    levelViewHandle = viewHandle.getLevel(levelHandle.getQualifiedName());
                }
                position = this.findPosition();
                LevelAttributeHandle[] levelAttributeHandleArray = this.levelAttributeHandles;
                int n = this.levelAttributeHandles.length;
                int n2 = 0;
                while (n2 < n) {
                    LevelAttributeHandle lah = levelAttributeHandleArray[n2];
                    DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)crosstabHandle.getModelHandle()), lah);
                    CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                    if (position > 0) {
                        cellHandle.addContent((DesignElementHandle)dataHandle, position);
                    } else {
                        cellHandle.addContent((DesignElementHandle)dataHandle);
                    }
                    ++n2;
                }
                this.transEnd();
            }
            catch (Exception e) {
                this.rollBack();
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    private int findCellPosition() {
        if (this.handleAdpter instanceof CrosstabCellAdapter) {
            int base = CrosstabAdaptUtil.getDimensionViewHandle((ExtendedItemHandle)((CrosstabCellAdapter)this.handleAdpter).getCrosstabCellHandle().getModelHandle()).getModelHandle().getIndex();
            return base + 1;
        }
        return 0;
    }

    private int findPosition() {
        if (this.after instanceof DesignElementHandle) {
            return ((DesignElementHandle)this.after).getIndex();
        }
        return 0;
    }

    public DimensionHandle[] getDimensionHandles() {
        return this.dimensionHandles;
    }

    public void setDimensionHandles(DimensionHandle[] dimensionHandles) {
        this.dimensionHandles = dimensionHandles;
    }
}

