/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.actions.EditAction;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.DeleteChildCommand;
import org.eclipse.bpel.ui.commands.DeleteLinkCommand;
import org.eclipse.bpel.ui.commands.RestoreSelectionCommand;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class BPELDeleteAction
extends EditAction {
    public static final String ID = "BPELDeleteAction";

    public BPELDeleteAction(IWorkbenchPart editor) {
        super(editor);
    }

    public BPELDeleteAction(IWorkbenchPart editor, String label) {
        super(editor);
        this.setText(label);
    }

    protected void init() {
        super.init();
        this.setText(Messages.DeleteSelectedAction_Delete_1);
        this.setToolTipText(Messages.DeleteSelectedAction_Delete_2);
        this.setId(ID);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    protected Command getCommand() {
        if (this.fSelection.isEmpty()) {
            return null;
        }
        BPELEditor bpelEditor = (BPELEditor)this.getWorkbenchPart();
        CompoundCommand cmd = new CompoundCommand(Messages.DeleteSelectedAction_Delete_3);
        cmd.add((Command)new RestoreSelectionCommand((ISelectionProvider)bpelEditor.getAdaptingSelectionProvider(), true, true));
        for (EObject next : this.fSelection) {
            if (next instanceof Link) {
                cmd.add((Command)new DeleteLinkCommand((Link)next));
                continue;
            }
            cmd.add((Command)new DeleteChildCommand(next));
        }
        int count = this.fSelection.size();
        if (count == 1) {
            cmd.setLabel(cmd.getLabel());
        } else if (count > 1) {
            cmd.setLabel(NLS.bind((String)Messages.DeleteSelectedAction_Delete_Items_3, (Object)count));
        } else {
            return UnexecutableCommand.INSTANCE;
        }
        return cmd;
    }

    @Override
    public void run() {
        this.fSelection = this.trimSelection(this.fSelection);
        Command cmd = this.getCommand();
        if (cmd == null) {
            return;
        }
        EObject modelObject = (EObject)this.fSelection.get(0);
        EObject parent = modelObject.eContainer();
        EObject sibling = null;
        IContainer container = BPELUtil.adapt((Object)parent, IContainer.class);
        if (container != null) {
            sibling = container.getNextSiblingChild(parent, modelObject);
        }
        this.execute(cmd);
        BPELEditor bpelEditor = (BPELEditor)this.getWorkbenchPart();
        bpelEditor.setFocus();
        if (sibling == null) {
            bpelEditor.getAdaptingSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            bpelEditor.getAdaptingSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)sibling));
        }
    }
}

