/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.AddToListCommand;
import org.eclipse.bpel.ui.uiextensionmodel.PartnerLinkExtension;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class AddPartnerLinkCommand
extends AddToListCommand {
    Process process;
    PartnerLink partnerLink;
    PartnerLinkExtension extension = null;
    Scope scope;

    public AddPartnerLinkCommand(EObject eObj, PartnerLink partnerLink, PartnerLinkExtension extension) {
        super(ModelHelper.getContainingScope(eObj), partnerLink, IBPELUIConstants.CMD_ADD_PARTNERLINK);
        if (this.target instanceof Process) {
            this.process = (Process)this.target;
        } else if (this.target instanceof Scope) {
            this.scope = (Scope)this.target;
        }
        this.partnerLink = partnerLink;
        this.extension = extension;
    }

    public AddPartnerLinkCommand(EObject eObj, PartnerLink partnerLink) {
        this(eObj, partnerLink, (PartnerLinkExtension)null);
    }

    protected EList<PartnerLink> getList() {
        if (this.process != null) {
            return this.process.getPartnerLinks().getChildren();
        }
        if (this.scope != null) {
            return this.scope.getPartnerLinks().getChildren();
        }
        throw new IllegalStateException("Container must either be a scope or a process");
    }

    @Override
    public void doExecute() {
        if (this.extension != null) {
            ModelHelper.getBPELEditor(this.process).getExtensionMap().put((Object)this.partnerLink, (Object)this.extension);
        }
        super.doExecute();
    }
}

