/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.List;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.providers.CompositeContentProvider;
import org.eclipse.bpel.ui.details.providers.MessageTypeContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.VariableTypeTreeContentProvider;
import org.eclipse.bpel.ui.details.providers.XSDSchemaFromResourceContentProvider;
import org.eclipse.bpel.ui.details.providers.XSDTypeOrElementContentProvider;
import org.eclipse.bpel.ui.dialogs.BrowseSelectorDialog;
import org.eclipse.bpel.ui.dialogs.NamespaceMappingDialog;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.Message;

public class TypeSelectorDialog
extends BrowseSelectorDialog {
    public static final int INCLUDE_SIMPLE_TYPES = 1;
    public static final int INCLUDE_COMPLEX_TYPES = 2;
    public static final int INCLUDE_ELEMENT_DECLARATIONS = 4;
    public static final int INCLUDE_PRIMITIVES = 8;
    public static final int INCLUDE_MESSAGE_TYPES = 16;
    public static final int INCLUDE_ALL = 255;
    public static final int INCLUDE_XSD_TYPES = 3;
    protected static final int BID_COMPLEX_TYPES = 1124;
    protected static final int BID_SIMPLE_TYPES = 1125;
    protected static final int BID_ELEMENT_DECLARATIONS = 1126;
    protected static final int BID_MESSAGES = 1127;
    protected static final int BID_XSD_PRIMITIVES = 1128;
    protected boolean showMessages = true;
    protected XSDTypeOrElementContentProvider xsdTypeProvider = new XSDTypeOrElementContentProvider();
    protected MessageTypeContentProvider messageTypeProvider = new MessageTypeContentProvider();
    private static final String FILTER_TYPES_KEY = "FilterTypes";
    private static final String SHOW_MESSAGES_KEY = "ShowMessages";
    protected int FILTER_TYPES = 255;
    protected int includeTypes = 255;
    protected boolean requireLowerTreeSelection = false;

    public TypeSelectorDialog(Shell parent, EObject eObj, int filter) {
        super(parent, new ModelLabelProvider(eObj));
        this.includeTypes = filter;
        this.modelObject = eObj;
        this.resourceContentProvider = new XSDSchemaFromResourceContentProvider(this.modelObject.eResource().getResourceSet());
        CompositeContentProvider ccp = new CompositeContentProvider();
        ccp.add(this.xsdTypeProvider);
        ccp.add(this.messageTypeProvider);
        this.contentProvider = ccp;
        this.treeContentProvider = new VariableTypeTreeContentProvider(true, true);
        this.setTitle(Messages.TypeSelectorDialog_4);
        this.setMessage(Messages.TypeSelectorDialog_5);
        this.setLowerViewLabel(Messages.TypeSelectorDialog_7);
        this.setBrowseFromLabel(Messages.TypeSelectorDialog_9);
        IDialogSettings settings = this.getDialogSettings();
        try {
            this.FILTER_TYPES = settings.getInt(FILTER_TYPES_KEY);
        }
        catch (Exception exception) {
            this.FILTER_TYPES = 255;
        }
        try {
            this.showMessages = settings.getBoolean(SHOW_MESSAGES_KEY);
        }
        catch (Exception exception) {
            this.showMessages = false;
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setProviderFilters();
        this.refresh();
        return control;
    }

    @Override
    protected void saveSettings() {
        super.saveSettings();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(FILTER_TYPES_KEY, this.FILTER_TYPES);
        settings.put(SHOW_MESSAGES_KEY, this.showMessages);
    }

    @Override
    protected void buttonPressed(int id, boolean checked, boolean bRefresh) {
        int bits = 0;
        switch (id) {
            case 1125: {
                bits = 1;
                break;
            }
            case 1124: {
                bits = 2;
                break;
            }
            case 1126: {
                bits = 4;
                break;
            }
            case 1128: {
                bits = 8;
                break;
            }
            case 1127: {
                this.showMessages = checked;
                this.setProviderFilters();
                bRefresh = true;
                break;
            }
            default: {
                super.buttonPressed(id, checked, bRefresh);
                return;
            }
        }
        if (bits != 0) {
            this.FILTER_TYPES = checked ? (this.FILTER_TYPES |= bits) : (this.FILTER_TYPES &= ~bits);
            this.setProviderFilters();
        }
        if (bRefresh) {
            this.refresh();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.TypeSelectorDialog_3, false);
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected void createBrowseFilterGroupButtons(Group group) {
        if ((this.includeTypes & 8) > 0) {
            this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_14, 1128, (this.FILTER_TYPES & 8) > 0);
        }
        if ((this.includeTypes & 1) > 0) {
            this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_15, 1125, (this.FILTER_TYPES & 1) > 0);
        }
        if ((this.includeTypes & 2) > 0) {
            this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_16, 1124, (this.FILTER_TYPES & 2) > 0);
        }
        if ((this.includeTypes & 4) > 0) {
            this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_17, 1126, (this.FILTER_TYPES & 4) > 0);
        }
        if ((this.includeTypes & 0x10) > 0) {
            this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_18, 1127, this.showMessages);
        }
        super.createBrowseFilterGroupButtons(group);
    }

    protected List collectItemsFromImports() {
        List list = ModelHelper.getSchemas(this.modelObject, true);
        if (this.showMessages) {
            list.addAll(ModelHelper.getDefinitions(this.modelObject));
        }
        return list;
    }

    protected void updateOkState() {
        super.updateOkState();
        boolean enabled = true;
        this.computeResult();
        Object obj = this.getFirstResult();
        if (obj instanceof Message && !this.checkNamespace((Message)obj)) {
            enabled = false;
        }
        if (this.getResult().length < 2 && this.requireLowerTreeSelection) {
            enabled = false;
        }
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(enabled);
        }
    }

    @Override
    protected void okPressed() {
        this.computeResult();
        Object obj = this.getFirstResult();
        if (obj instanceof Message && !this.checkNamespace((Message)obj)) {
            return;
        }
        if (this.getResult().length < 2 && this.requireLowerTreeSelection) {
            return;
        }
        super.okPressed();
    }

    private boolean checkNamespace(Message message) {
        String targetNamespace = message.getQName().getNamespaceURI();
        String prefix = BPELUtils.getNamespacePrefix((EObject)this.modelObject, (String)targetNamespace);
        if (prefix != null) {
            return true;
        }
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.getShell(), this.modelObject);
        dialog.setNamespace(targetNamespace);
        if (dialog.open() == 1) {
            return false;
        }
        BPELUtils.setPrefix((EObject)BPELUtils.getProcess((Object)this.modelObject), (String)targetNamespace, (String)dialog.getPrefix());
        return true;
    }

    public void setRequireLowerTreeSelection(boolean enabled) {
        this.requireLowerTreeSelection = enabled;
    }

    public void setIncludeTypes(int includeTypes) {
        this.includeTypes = includeTypes;
    }

    private void setProviderFilters() {
        this.xsdTypeProvider.setFilter(this.FILTER_TYPES & this.includeTypes);
        if ((this.includeTypes & 0x10) > 0) {
            this.messageTypeProvider.setFilter(this.showMessages ? 1 : 0);
        } else {
            this.messageTypeProvider.setFilter(0);
        }
    }
}

