/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;

public class BPELConnectionCreationTool
extends AbstractConnectionCreationTool {
    private EditPartViewer viewer;
    private EditPart source;
    private EditPart proposedTarget;
    private boolean lastProposedTargetConnectable;

    public BPELConnectionCreationTool(CreationFactory factory) {
        super(factory);
        this.setDefaultCursor(Cursors.ARROW);
        this.setFactory(factory);
        this.setUnloadWhenFinished(true);
    }

    protected boolean handleKeyDown(KeyEvent event) {
        boolean ret = this.ourHandleKeyDown(event);
        this.getDomain().getActiveTool();
        return ret;
    }

    protected void handleFinished() {
        super.handleFinished();
    }

    public void setInitialAnchor(EditPart part, EditPartViewer curViewer) {
        this.setViewer(curViewer);
        this.setTargetEditPart(part);
        this.updateTargetRequest();
        this.setConnectionSource(part);
        Command command = this.getCommand();
        ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(part);
        this.source = part;
        this.proposedTarget = null;
        this.lastProposedTargetConnectable = false;
        if (command != null) {
            this.setState(64);
            this.setCurrentCommand(command);
            this.viewer = this.getCurrentViewer();
        }
        if (this.isInState(64)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.stateTransition(64, 0x40000000)) {
            boolean ret = this.handleCreateConnection();
            if (this.getCommand() != null) {
                this.handleFinished();
            }
            return ret;
        }
        if (this.isInState(1) && button == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.setConnectionSource(this.getTargetEditPart());
            Command command = this.getCommand();
            ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
            if (command != null) {
                this.setState(64);
                this.setCurrentCommand(command);
                this.viewer = this.getCurrentViewer();
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    public void deactivate() {
        this.viewer = null;
        super.deactivate();
    }

    protected boolean handleMove() {
        if (this.isInState(64) && this.viewer != this.getCurrentViewer()) {
            return false;
        }
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            Collection exclude = this.getExclusionSet();
            EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), exclude, this.getTargetingConditional());
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            boolean changed = this.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }

    protected EditPartViewer.Conditional getTargetingConditional() {
        return new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                EditPart target = editpart.getTargetEditPart(BPELConnectionCreationTool.this.getTargetRequest());
                if (target == null) {
                    return false;
                }
                if (target == BPELConnectionCreationTool.this.proposedTarget) {
                    return BPELConnectionCreationTool.this.lastProposedTargetConnectable;
                }
                if (target.getParent() instanceof FlowEditPart) {
                    BPELConnectionCreationTool.this.lastProposedTargetConnectable = ((FlowEditPart)target.getParent()).detectImpendingCycle(BPELConnectionCreationTool.this.source, target);
                } else {
                    BPELConnectionCreationTool.this.lastProposedTargetConnectable = true;
                }
                BPELConnectionCreationTool.this.proposedTarget = target;
                return BPELConnectionCreationTool.this.lastProposedTargetConnectable;
            }
        };
    }

    boolean acceptConnectionFinish(KeyEvent event) {
        return this.isInState(96) && event.character == '\r';
    }

    boolean acceptConnectionStart(KeyEvent event) {
        return this.isInState(1) && event.character == '\r';
    }

    protected boolean handleFocusLost() {
        if (this.isInState(96)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    private boolean ourAcceptArrowKey(KeyEvent e) {
        int key = e.keyCode;
        if (!this.isInState(113)) {
            return false;
        }
        return key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003;
    }

    private boolean ourHandleKeyDown(KeyEvent event) {
        if (this.ourAcceptArrowKey(event)) {
            int direction = 0;
            switch (event.keyCode) {
                case 0x1000002: {
                    direction = 4;
                    break;
                }
                case 0x1000001: {
                    direction = 1;
                    break;
                }
                case 0x1000004: {
                    direction = 16;
                    break;
                }
                case 0x1000003: {
                    direction = 8;
                }
            }
            boolean consumed = false;
            if (direction != 0 && event.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                event.stateMask |= 0x40000;
                event.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                    this.navigateNextAnchor(0);
                    this.updateTargetRequest();
                    this.updateTargetUnderMouse();
                    Command command = this.getCommand();
                    if (command != null) {
                        this.setCurrentCommand(command);
                    }
                    return true;
                }
            }
        }
        if (this.acceptConnectionStart(event)) {
            this.updateTargetUnderMouse();
            this.setConnectionSource(this.getTargetEditPart());
            ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(this.getTargetEditPart());
            this.setState(32);
            this.ourPlaceMouseInViewer(this.getLocation().getTranslated(6, 6));
            return true;
        }
        if (this.acceptConnectionFinish(event)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.setState(1);
                this.ourPlaceMouseInViewer(this.getLocation().getTranslated(6, 6));
                this.eraseSourceFeedback();
                this.eraseTargetFeedback();
                this.setCurrentCommand(command);
                this.executeCurrentCommand();
                this.handleFinished();
            }
            return true;
        }
        return super.handleKeyDown(event);
    }

    boolean navigateNextAnchor(int direction) {
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        AccessibleAnchorProvider provider = (AccessibleAnchorProvider)focus.getAdapter(AccessibleAnchorProvider.class);
        if (provider == null) {
            return false;
        }
        List list = this.isInState(32) ? provider.getTargetAnchorLocations() : provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        int i = 0;
        while (i < list.size()) {
            int d;
            Point p = (Point)list.get(i);
            if (!(p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance)) {
                distance = d;
                next = p;
            }
            ++i;
        }
        if (next != null) {
            this.ourPlaceMouseInViewer(next);
            return true;
        }
        return false;
    }

    void ourPlaceMouseInViewer(Point p) {
        if (this.getCurrentViewer() == null) {
            return;
        }
        Control c = this.getCurrentViewer().getControl();
        Rectangle rect = c instanceof Scrollable ? ((Scrollable)c).getClientArea() : c.getBounds();
        if (p.x > rect.x + rect.width - 1) {
            p.x = rect.x + rect.width - 1;
        } else if (p.x < rect.x) {
            p.x = rect.x;
        }
        if (p.y > rect.y + rect.height - 1) {
            p.y = rect.y + rect.height - 1;
        } else if (p.y < rect.y) {
            p.y = rect.y;
        }
        org.eclipse.swt.graphics.Point swt = new org.eclipse.swt.graphics.Point(p.x, p.y);
        swt = c.toDisplay(swt);
        c.getDisplay().setCursorLocation(swt);
    }
}

