/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.make.internal.ui.preferences.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractMakefileEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    OverlayPreferenceStore fOverlayStore;
    Map<Control, String> fCheckBoxes = new HashMap<Control, String>();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractMakefileEditorPreferencePage.this.fOverlayStore.setValue(AbstractMakefileEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    Map<Control, String> fTextFields = new HashMap<Control, String>();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractMakefileEditorPreferencePage.this.fOverlayStore.setValue(AbstractMakefileEditorPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private Map<Text, String[]> fNumberFields = new HashMap<Text, String[]>();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AbstractMakefileEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };

    public AbstractMakefileEditorPreferencePage() {
        this.setPreferenceStore(MakeUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected abstract OverlayPreferenceStore createOverlayStore();

    public void init(IWorkbench workbench) {
    }

    protected void initializeFields() {
        String key;
        Map<Control, String> checkBoxes = this.getCheckBoxes();
        Map<Control, String> textFields = this.getTextFields();
        for (Button button : checkBoxes.keySet()) {
            key = checkBoxes.get(button);
            button.setSelection(this.getOverlayStore().getBoolean(key));
        }
        for (Text text : textFields.keySet()) {
            key = textFields.get(text);
            text.setText(this.getOverlayStore().getString(key));
        }
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        MakeUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    protected OverlayPreferenceStore setOverlayStore() {
        return this.fOverlayStore;
    }

    protected Map<Control, String> getCheckBoxes() {
        return this.fCheckBoxes;
    }

    protected Map<Control, String> getTextFields() {
        return this.fTextFields;
    }

    protected Map<Text, String[]> getNumberFields() {
        return this.fNumberFields;
    }

    protected void performDefaults() {
        this.getOverlayStore().loadDefaults();
        this.initializeFields();
        this.handleDefaults();
        super.performDefaults();
    }

    protected abstract void handleDefaults();

    public void dispose() {
        if (this.getOverlayStore() != null) {
            this.getOverlayStore().stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    protected Button addCheckBox(Composite parent, String labelText, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(labelText);
        checkBox.setFont(parent.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.getCheckBoxes().put((Control)checkBox, key);
        return checkBox;
    }

    protected Control addTextField(Composite composite, String labelText, String key, int textLimit, int indentation, String[] errorMessages) {
        Font font = composite.getFont();
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setFont(font);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        label.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        textControl.setFont(font);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.getTextFields().put((Control)textControl, key);
        if (errorMessages != null) {
            this.getNumberFields().put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number, this.getNumberFields().get(textControl));
        if (!status.matches(4)) {
            this.getOverlayStore().setValue(this.getTextFields().get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number, String[] errorMessages) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(errorMessages[0]);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(MessageFormat.format((String)errorMessages[1], (Object[])new Object[]{number}));
                }
            }
            catch (NumberFormatException e) {
                status.setError(MessageFormat.format((String)errorMessages[1], (Object[])new Object[]{number}));
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Set<Text> keys = this.getNumberFields().keySet();
            for (Text text : keys) {
                IStatus s = this.validatePositiveNumber(text.getText(), this.getNumberFields().get(text));
                IStatus iStatus = status = s.getSeverity() > status.getSeverity() ? s : status;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    private void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, String[] errorMessages) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setFont(composite.getFont());
        this.fTextFields.put((Control)textControl, key);
        if (errorMessages != null) {
            this.fNumberFields.put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    protected String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            String separator = System.getProperty("line.separator", "\n");
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    MakeUIPlugin.log(io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buffer.toString();
    }
}

