/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;

public class ArchiveEntryFile
extends PlatformObject
implements IStorage {
    private String entryName;
    private String zipName;
    private IPath path;
    private IResource zipResource;
    private ArchiveProjectFragment archiveProjectFragment;

    public ArchiveEntryFile(String entryName, String zipName, IPath parentRelativePath, IResource zipResource, ArchiveProjectFragment archiveProjectFragment) {
        this.entryName = entryName;
        this.zipName = zipName;
        this.path = parentRelativePath;
        this.zipResource = zipResource;
        this.archiveProjectFragment = archiveProjectFragment;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getContents() throws CoreException {
        try {
            ByteArrayInputStream byteArrayInputStream;
            IArchive zipFile;
            block14: {
                InputStream inputStream;
                block12: {
                    ByteArrayInputStream byteArrayInputStream2;
                    block13: {
                        if (ModelManager.ZIP_ACCESS_VERBOSE) {
                            System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
                        }
                        zipFile = null;
                        inputStream = null;
                        zipFile = this.zipResource == null ? ModelManager.getModelManager().getArchive((IPath)new Path(this.zipName), this.archiveProjectFragment) : ModelManager.getModelManager().getArchive(this.zipResource.getLocation(), this.archiveProjectFragment);
                        IArchiveEntry zipEntry = zipFile.getArchiveEntry(this.path.append(this.entryName).toString());
                        if (zipEntry == null) {
                            throw new ModelException(new ModelStatus(979, this.entryName));
                        }
                        inputStream = zipFile.getInputStream(zipEntry);
                        int entrySize = (int)zipEntry.getSize();
                        if (entrySize < 0) break block12;
                        byte[] buf = new byte[entrySize];
                        int offset = 0;
                        while (true) {
                            void len3;
                            int len2;
                            if (entrySize <= offset || (len2 = inputStream.read(buf, offset, entrySize - offset)) <= 0) {
                                byteArrayInputStream2 = new ByteArrayInputStream(buf, 0, offset);
                                if (inputStream != null) {
                                    break;
                                }
                                break block13;
                            }
                            offset += len3;
                        }
                        inputStream.close();
                    }
                    ModelManager.getModelManager().closeArchive(zipFile);
                    return byteArrayInputStream2;
                }
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
                    while ((len = inputStream.read(buf)) > 0) {
                        arrayOut.write(buf, 0, len);
                    }
                    byteArrayInputStream = new ByteArrayInputStream(arrayOut.toByteArray());
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    ModelManager.getModelManager().closeArchive(zipFile);
                    throw throwable;
                }
                inputStream.close();
            }
            ModelManager.getModelManager().closeArchive(zipFile);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return this.path.append(this.entryName);
    }

    public String getName() {
        return new Path(this.entryName).lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
    }
}

