/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.ui.wizards.buildpath.ArchiveFileFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public class BPListElement {
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    public static final String ACCESSRULES = "accessrules";
    public static final String COMBINE_ACCESSRULES = "combineaccessrules";
    public static final String NATIVE_LIB_PATH = ScriptRuntime.BUILDPATH_ATTR_LIBRARY_PATH_ENTRY;
    private IScriptProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IPath sourcePath;
    private IPath sourceRootPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fExternal;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IBuildpathEntry fCachedEntry;
    private ArrayList fChildren;
    private IPath fLinkTarget;
    private IPath fOrginalLinkTarget;
    private List fExtraAttributes = new ArrayList();

    public BPListElement(IScriptProject project, int entryKind, IPath path, IResource res, boolean external) {
        this(null, project, entryKind, path, res, external);
    }

    public BPListElement(Object parent, IScriptProject project, int entryKind, IPath path, IResource res, boolean external) {
        this(parent, project, entryKind, path, res, null, external);
    }

    public BPListElement(IScriptProject project, int entryKind, boolean external) {
        this(null, project, entryKind, null, null, external);
    }

    public BPListElement(Object parent, IScriptProject project, int entryKind, IPath path, IResource res, IPath linkTarget, boolean external) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fOrginalPath = path;
        this.fLinkTarget = linkTarget;
        this.fOrginalLinkTarget = linkTarget;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        this.fExternal = external;
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                if (!DLTKCore.DEBUG) break;
                System.err.println("TODO: Add adding containers for languages here");
                break;
            }
            case 1: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                break;
            }
            case 2: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                this.createAttributeElement(COMBINE_ACCESSRULES, Boolean.FALSE, true);
                if (!DLTKCore.DEBUG) break;
                System.err.println("TODO: Add adding containers for languages here");
                break;
            }
            case 5: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                try {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)this.fPath, (IScriptProject)this.fProject);
                    if (container != null) {
                        IBuildpathEntry[] entries = container.getBuildpathEntries();
                        int i = 0;
                        while (i < entries.length) {
                            IBuildpathEntry entry = entries[i];
                            if (entry != null) {
                                BPListElement curr = BPListElement.createFromExisting(this, entry, this.fProject);
                                this.fChildren.add(curr);
                            } else {
                                DLTKUIPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                            }
                            ++i;
                        }
                    }
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
                if (!DLTKCore.DEBUG) break;
                System.err.println("TODO: Add adding containers for languages here");
            }
        }
    }

    public IBuildpathEntry getBuildpathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newBuildpathEntry();
            this.fCachedEntry.setSourceAttachmentPath(this.getSourcePath());
            this.fCachedEntry.setSourceAttachmentRootPath(this.getSourceRootPath());
        }
        return this.fCachedEntry;
    }

    private IBuildpathAttribute[] getBuildpathAttributes() {
        ArrayList<IBuildpathAttribute> res = new ArrayList<IBuildpathAttribute>();
        int i = 0;
        while (i < this.fChildren.size()) {
            BPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof BPListElementAttribute && !(elem = (BPListElementAttribute)curr).isBuiltIn() && elem.getValue() != null) {
                res.add(elem.newBuildpathAttribute());
            }
            ++i;
        }
        res.addAll(this.fExtraAttributes);
        return res.toArray(new IBuildpathAttribute[res.size()]);
    }

    private IBuildpathEntry newBuildpathEntry() {
        IBuildpathAttribute[] extraAttributes = this.getBuildpathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] inclusionPattern = (IPath[])this.getAttribute(INCLUSION);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                return DLTKCore.newSourceEntry((IPath)this.fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (IBuildpathAttribute[])extraAttributes);
            }
            case 1: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                if (this.fPath.toString().startsWith("#special#builtin#")) {
                    return DLTKCore.newBuiltinEntry((IPath)this.fPath, (IAccessRule[])accesRules, (IBuildpathAttribute[])extraAttributes, (IPath[])new IPath[0], (IPath[])BuildpathEntry.INCLUDE_ALL, (boolean)this.isExported(), (boolean)this.fExternal);
                }
                return DLTKCore.newLibraryEntry((IPath)this.fPath, (IAccessRule[])accesRules, (IBuildpathAttribute[])extraAttributes, (boolean)this.isExported(), (boolean)this.fExternal);
            }
            case 2: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                boolean combineAccessRules = (Boolean)this.getAttribute(COMBINE_ACCESSRULES);
                return DLTKCore.newProjectEntry((IPath)this.fPath, (IAccessRule[])accesRules, (boolean)combineAccessRules, (IBuildpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 5: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return DLTKCore.newContainerEntry((IPath)this.fPath, (IAccessRule[])accesRules, (IBuildpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IPath getSourcePath() {
        return this.sourcePath;
    }

    public IPath getSourceRootPath() {
        return this.sourceRootPath;
    }

    public void setSourcePath(IPath sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setSourceRootPath(IPath sourceRootPath) {
        this.sourceRootPath = sourceRootPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public BPListElementAttribute setAttribute(String key, Object value) {
        BPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        if (key.equals(EXCLUSION) || key.equals(INCLUSION)) {
            Assert.isTrue((value != null || this.fEntryKind != 3 ? 1 : 0) != 0);
        }
        if (key.equals(ACCESSRULES)) {
            Assert.isTrue((value != null || this.fEntryKind == 3 ? 1 : 0) != 0);
        }
        if (key.equals(COMBINE_ACCESSRULES)) {
            Assert.isTrue((boolean)(value instanceof Boolean));
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    public boolean addToExclusions(IPath path) {
        String key = EXCLUSION;
        return this.addFilter(path, key);
    }

    public boolean addToInclusion(IPath path) {
        String key = INCLUSION;
        return this.addFilter(path, key);
    }

    public boolean removeFromExclusions(IPath path) {
        String key = EXCLUSION;
        return this.removeFilter(path, key);
    }

    public boolean removeFromInclusion(IPath path) {
        String key = INCLUSION;
        return this.removeFilter(path, key);
    }

    private boolean addFilter(IPath path, String key) {
        IPath[] exclusionFilters = (IPath[])this.getAttribute(key);
        if (!ScriptModelUtil.isExcludedPath((IPath)path, (IPath[])exclusionFilters)) {
            IPath pathToExclude = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            this.setAttribute(key, newExclusionFilters);
            return true;
        }
        return false;
    }

    private boolean removeFilter(IPath path, String key) {
        IPath[] exclusionFilters = (IPath[])this.getAttribute(key);
        IPath pathToExclude = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
        if (ScriptModelUtil.isExcludedPath((IPath)pathToExclude, (IPath[])exclusionFilters)) {
            ArrayList<IPath> l = new ArrayList<IPath>(Arrays.asList(exclusionFilters));
            l.remove(pathToExclude);
            IPath[] newExclusionFilters = l.toArray(new IPath[l.size()]);
            this.setAttribute(key, newExclusionFilters);
            return true;
        }
        return false;
    }

    public BPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            BPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof BPListElementAttribute && key.equals((elem = (BPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        BPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new BPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof BPListElementAttribute) {
            String key = ((BPListElementAttribute)entry).getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList res = new ArrayList(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!BPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren() {
        if (this.fParentContainer instanceof BPListElement && DLTKCore.DEBUG) {
            System.err.println("TODO:Add navive library containers support");
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[]{COMBINE_ACCESSRULES});
        }
        return this.fChildren.toArray();
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    public void setParentContainer(Object parent) {
        this.fParentContainer = parent;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    private boolean canUpdateContainer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)this.fPath.segment(0));
            return initializer != null && initializer.canUpdateBuildpathContainer(this.fPath, this.fProject);
        }
        return false;
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer instanceof BPListElement) {
            return !((BPListElement)this.fParentContainer).canUpdateContainer();
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            BPListElement elem = (BPListElement)other;
            if (this.fExtraAttributes.size() != elem.fExtraAttributes.size()) {
                HashSet ns = new HashSet();
                ns.addAll(this.fExtraAttributes);
                ns.removeAll(elem.fExtraAttributes);
                if (ns.size() > 0) {
                    return false;
                }
            }
            return this.getBuildpathEntry().equals(elem.getBuildpathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getBuildpathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IScriptProject getScriptProject() {
        return this.fProject;
    }

    public static BPListElement createFromExisting(IBuildpathEntry curr, IScriptProject project) {
        return BPListElement.createFromExisting(null, curr, project);
    }

    public static BPListElement createFromExisting(Object parent, IBuildpathEntry curr, IScriptProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        IPath linkTarget = null;
        boolean isExternel = false;
        switch (curr.getEntryKind()) {
            case 5: {
                try {
                    isMissing = project != null && DLTKCore.getBuildpathContainer((IPath)path, (IScriptProject)project) == null;
                }
                catch (ModelException e) {
                    isMissing = true;
                }
                break;
            }
            case 1: {
                res = root.findMember(path);
                isExternel = curr.isExternal();
                if (res == null) {
                    if (!ArchiveFileFilter.isArchivePath(path) && root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                        res = root.getFolder(path);
                    }
                    if (path.toString().startsWith("#special#builtin#")) {
                        isMissing = false;
                        break;
                    }
                    IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                    IFileHandle handle = EnvironmentPathUtils.getFile((IEnvironment)environment, (IPath)path);
                    if (handle != null && handle.exists()) break;
                    isMissing = true;
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    isMissing = true;
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        BPListElement elem = new BPListElement(parent, project, curr.getEntryKind(), path, res, linkTarget, isExternel);
        elem.setExported(curr.isExported());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setAttribute(INCLUSION, curr.getInclusionPatterns());
        elem.setAttribute(ACCESSRULES, curr.getAccessRules());
        elem.setAttribute(COMBINE_ACCESSRULES, curr.combineAccessRules());
        elem.setSourcePath(curr.getSourceAttachmentPath());
        elem.setSourceRootPath(curr.getSourceAttachmentRootPath());
        IBuildpathAttribute[] extraAttributes = curr.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IBuildpathAttribute attrib = extraAttributes[i];
            if (elem.setAttribute(attrib.getName(), attrib.getValue()) == null) {
                elem.fExtraAttributes.add(attrib);
            }
            ++i;
        }
        if (project != null && project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                BPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedAccessRules(IAccessRule[] rules, StringBuffer buf) {
        if (rules != null) {
            buf.append('[').append(rules.length).append(']');
            int i = 0;
            while (i < rules.length) {
                BPListElement.appendEncodePath(rules[i].getPattern(), buf).append(';');
                buf.append(rules[i].getKind()).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        if (this.getLinkTarget() == null) {
            BPListElement.appendEncodePath(this.fPath, buf).append(';');
        } else {
            BPListElement.appendEncodePath(this.fPath, buf).append('-').append('>');
            BPListElement.appendEncodePath(this.getLinkTarget(), buf).append(';');
        }
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof BPListElementAttribute) {
                BPListElementAttribute elem = (BPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    String key = elem.getKey();
                    if (EXCLUSION.equals(key) || INCLUSION.equals(key)) {
                        BPListElement.appendEncodedFilter((IPath[])elem.getValue(), buf).append(';');
                    } else if (ACCESSRULES.equals(key)) {
                        BPListElement.appendEncodedAccessRules((IAccessRule[])elem.getValue(), buf).append(';');
                    } else if (COMBINE_ACCESSRULES.equals(key)) {
                        buf.append((Boolean)elem.getValue()).append(';');
                    }
                } else {
                    BPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        for (IBuildpathAttribute attr : this.fExtraAttributes) {
            BPListElement.appendEncodedString("attr:" + attr.getName() + ":val" + attr.getValue() + ";", buf);
        }
        return buf;
    }

    public IPath getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setPath(IPath path) {
        this.fCachedEntry = null;
        this.fPath = path;
    }

    public void setLinkTarget(IPath linkTarget) {
        this.fCachedEntry = null;
        this.fLinkTarget = linkTarget;
    }

    public static void insert(BPListElement element, List<BPListElement> cpList) {
        int length = cpList.size();
        BPListElement[] elements = cpList.toArray(new BPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != element.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == element.getEntryKind()) {
                ++i;
            }
            cpList.add(i, element);
            return;
        }
        switch (element.getEntryKind()) {
            case 3: {
                cpList.add(0, element);
                break;
            }
            default: {
                cpList.add(element);
            }
        }
    }

    public static IBuildpathEntry[] convertToBuildpathEntries(List cpList) {
        IBuildpathEntry[] result = new IBuildpathEntry[cpList.size()];
        int i = 0;
        for (BPListElement cur : cpList) {
            result[i] = cur.getBuildpathEntry();
            ++i;
        }
        return result;
    }

    public static BPListElement[] createFromExisting(IScriptProject project) throws ModelException {
        IBuildpathEntry[] rawBuildpath = project.getRawBuildpath();
        BPListElement[] result = new BPListElement[rawBuildpath.length];
        int i = 0;
        while (i < rawBuildpath.length) {
            result[i] = BPListElement.createFromExisting(rawBuildpath[i], project);
            ++i;
        }
        return result;
    }

    public static boolean isProjectSourceFolder(BPListElement[] existing, IScriptProject project) {
        IPath projPath = project.getProject().getFullPath();
        int i = 0;
        while (i < existing.length) {
            IBuildpathEntry curr = existing[i].getBuildpathEntry();
            if (curr.getEntryKind() == 3 && projPath.equals((Object)curr.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }

    public IPath getOrginalLinkTarget() {
        return this.fOrginalLinkTarget;
    }

    public boolean isExternalFolder() {
        return this.fExternal && this.fEntryKind == 1 && !Util.isArchiveFileName((IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)this.getScriptProject()), (String)this.fPath.toOSString());
    }
}

